/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.zine.common.util.codec;

import com.eightsidedsquare.zine.common.util.codec.AlternativeCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_11368;
import net.minecraft.class_2248;
import net.minecraft.class_2379;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3730;
import net.minecraft.class_5251;
import net.minecraft.class_5699;
import net.minecraft.class_7923;

public final class CodecUtil {
    public static final Codec<Character> CHARACTER = Codec.string((int)1, (int)1).xmap(string -> Character.valueOf(string.charAt(0)), String::valueOf);
    public static final Codec<class_2379> EULER_ANGLE = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.optionalFieldOf("pitch", (Object)Float.valueOf(0.0f)).forGetter(class_2379::comp_3776), (App)Codec.FLOAT.optionalFieldOf("yaw", (Object)Float.valueOf(0.0f)).forGetter(class_2379::comp_3777), (App)Codec.FLOAT.optionalFieldOf("roll", (Object)Float.valueOf(0.0f)).forGetter(class_2379::comp_3778)).apply((Applicative)instance, class_2379::new));
    public static final Codec<Integer> INT_STRING = Codec.STRING.comapFlatMap(string -> {
        int value;
        try {
            value = Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            return DataResult.error(() -> "Failed to parse int from " + string);
        }
        return DataResult.success((Object)value);
    }, String::valueOf);
    public static final Codec<class_2248> BLOCK = class_7923.field_41175.method_39673();
    public static final Codec<Integer> COLOR = AlternativeCodec.create(class_5699.field_54067, class_5251.field_39242, color -> Optional.of(class_5251.method_27717((int)color)), textColor -> textColor.method_27716() | 0xFF000000);
    public static final class_5699.class_10388<class_2960, class_3730> SPAWN_REASON_IDS = CodecUtil.createSpawnReasonIds();
    public static final Codec<class_3730> SPAWN_REASON = SPAWN_REASON_IDS.method_65323(class_2960.field_25139);

    public static <A> Codec<List<A>> listCodec(Codec<A> codec) {
        return Codec.either(codec, (Codec)codec.listOf()).xmap(either -> (List)either.map(List::of, list -> list), list -> list.size() == 1 ? Either.left(list.getFirst()) : Either.right((Object)list));
    }

    public static <A> Codec<List<A>> nonEmptyListCodec(Codec<A> codec) {
        return CodecUtil.listCodec(codec).validate(list -> list.isEmpty() ? DataResult.error(() -> "Empty list") : DataResult.success((Object)list));
    }

    public static <O, T> Codec<O> codec(RecordCodecBuilder<O, T> field, Function<T, O> function) {
        return RecordCodecBuilder.create(instance -> instance.group((App)field).apply((Applicative)instance, function));
    }

    public static <O, T> MapCodec<O> mapCodec(RecordCodecBuilder<O, T> field, Function<T, O> function) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)field).apply((Applicative)instance, function));
    }

    public static Codec<class_2248> blockCodecWithProperties(class_2769<?> ... properties) {
        return BLOCK.validate(block -> {
            Collection blockProperties = block.method_9595().method_11659();
            for (class_2769 property : properties) {
                if (blockProperties.contains(property)) continue;
                return DataResult.error(() -> String.valueOf(block) + " does not contain property " + String.valueOf(property));
            }
            return DataResult.success((Object)block);
        });
    }

    public static Codec<class_2248> blockCodecWithPropertiesOf(class_2248 block) {
        return CodecUtil.blockCodecWithProperties(block.method_9595().method_11659().toArray(new class_2769[0]));
    }

    public static <T> void readToList(class_11368 view, String key, List<T> list, Codec<? extends Collection<? extends T>> codec) {
        list.clear();
        view.method_71426(key, codec).ifPresent(list::addAll);
    }

    public static <K, V> void readToMap(class_11368 view, String key, Map<K, V> map, Codec<? extends Map<? extends K, ? extends V>> codec) {
        map.clear();
        view.method_71426(key, codec).ifPresent(map::putAll);
    }

    private static class_5699.class_10388<class_2960, class_3730> createSpawnReasonIds() {
        class_5699.class_10388 ids = new class_5699.class_10388();
        ids.method_65325((Object)class_2960.method_60656((String)"natural"), (Object)class_3730.field_16459);
        ids.method_65325((Object)class_2960.method_60656((String)"chunk_generation"), (Object)class_3730.field_16472);
        ids.method_65325((Object)class_2960.method_60656((String)"spawner"), (Object)class_3730.field_16469);
        ids.method_65325((Object)class_2960.method_60656((String)"structure"), (Object)class_3730.field_16474);
        ids.method_65325((Object)class_2960.method_60656((String)"breeding"), (Object)class_3730.field_16466);
        ids.method_65325((Object)class_2960.method_60656((String)"mob_summoned"), (Object)class_3730.field_16471);
        ids.method_65325((Object)class_2960.method_60656((String)"jockey"), (Object)class_3730.field_16460);
        ids.method_65325((Object)class_2960.method_60656((String)"event"), (Object)class_3730.field_16467);
        ids.method_65325((Object)class_2960.method_60656((String)"conversion"), (Object)class_3730.field_16468);
        ids.method_65325((Object)class_2960.method_60656((String)"reinforcement"), (Object)class_3730.field_16463);
        ids.method_65325((Object)class_2960.method_60656((String)"triggered"), (Object)class_3730.field_16461);
        ids.method_65325((Object)class_2960.method_60656((String)"bucket"), (Object)class_3730.field_16473);
        ids.method_65325((Object)class_2960.method_60656((String)"spawn_item_use"), (Object)class_3730.field_16465);
        ids.method_65325((Object)class_2960.method_60656((String)"command"), (Object)class_3730.field_16462);
        ids.method_65325((Object)class_2960.method_60656((String)"dispenser"), (Object)class_3730.field_16470);
        ids.method_65325((Object)class_2960.method_60656((String)"patrol"), (Object)class_3730.field_16527);
        ids.method_65325((Object)class_2960.method_60656((String)"trial_spawner"), (Object)class_3730.field_47245);
        ids.method_65325((Object)class_2960.method_60656((String)"load"), (Object)class_3730.field_52444);
        ids.method_65325((Object)class_2960.method_60656((String)"dimension_travel"), (Object)class_3730.field_52445);
        return ids;
    }

    private CodecUtil() {
    }
}

