/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.zine.client.atlas.generator;

import com.eightsidedsquare.zine.client.atlas.GeneratorAtlasSource;
import com.eightsidedsquare.zine.client.atlas.generator.SpriteGenerator;
import com.eightsidedsquare.zine.client.atlas.generator.SpriteProperties;
import com.eightsidedsquare.zine.client.atlas.gradient.Gradient;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5216;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import org.joml.Vector2f;
import org.joml.Vector3f;

public record NoiseSpriteGenerator(Gradient gradient, class_5216.class_5487 parameters, long seed, Vector2f scale, Vector3f velocity, float blendMargin) implements SpriteGenerator
{
    public static final MapCodec<NoiseSpriteGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Gradient.CODEC.fieldOf("gradient").forGetter(NoiseSpriteGenerator::gradient), (App)class_5216.class_5487.field_35424.fieldOf("parameters").forGetter(NoiseSpriteGenerator::parameters), (App)Codec.LONG.optionalFieldOf("seed", (Object)0L).forGetter(NoiseSpriteGenerator::seed), (App)class_5699.field_59993.optionalFieldOf("scale", (Object)new Vector2f(1.0f, 1.0f)).forGetter(NoiseSpriteGenerator::scale), (App)class_5699.field_40723.optionalFieldOf("velocity", (Object)new Vector3f(0.0f, 0.0f, 1.0f)).forGetter(NoiseSpriteGenerator::velocity), (App)Codec.floatRange((float)0.0f, (float)0.5f).optionalFieldOf("blend_margin", (Object)Float.valueOf(0.0f)).forGetter(NoiseSpriteGenerator::blendMargin)).apply((Applicative)instance, NoiseSpriteGenerator::new));

    @Override
    public MapCodec<? extends SpriteGenerator> getCodec() {
        return CODEC;
    }

    @Override
    public GeneratorAtlasSource.Output generate(class_2960 outputId, SpriteProperties properties) {
        class_5216 sampler = class_5216.method_38476((class_5819)class_5819.method_43049((long)this.seed), (class_5216.class_5487)this.parameters);
        if (this.blendMargin == 0.0f) {
            return (u, v, w) -> this.gradient.get(this.value(sampler, u, v, w), 0.0f, w);
        }
        return (u, v, w) -> this.gradient.get(this.valueUVW(sampler, u, v, w), 0.0f, w);
    }

    private float valueU(class_5216 sampler, float u, float v, float w) {
        float blend = this.blendFac(u);
        float a = this.value(sampler, u, v, w);
        if (blend == 0.0f) {
            return a;
        }
        float b = this.value(sampler, 1.0f - u, v, w);
        return class_3532.method_16439((float)blend, (float)a, (float)b);
    }

    private float valueUV(class_5216 sampler, float u, float v, float w) {
        float blend = this.blendFac(v);
        float a = this.valueU(sampler, u, v, w);
        if (blend == 0.0f) {
            return a;
        }
        float b = this.valueU(sampler, u, 1.0f - v, w);
        return class_3532.method_16439((float)blend, (float)a, (float)b);
    }

    private float valueUVW(class_5216 sampler, float u, float v, float w) {
        float blend = this.blendFac(w);
        float a = this.valueUV(sampler, u, v, w);
        if (blend == 0.0f) {
            return a;
        }
        float b = this.valueUV(sampler, u, v, 1.0f - w);
        return class_3532.method_16439((float)blend, (float)a, (float)b);
    }

    private float value(class_5216 sampler, float u, float v, float w) {
        double value = sampler.method_27406((double)(u * this.scale.x + this.velocity.x * w), (double)(v * this.scale.y + this.velocity.y * w), (double)(this.velocity.z * w));
        return (float)(value + 1.0) * 0.5f;
    }

    private float blendFac(float x) {
        float r = 1.0f / (2.0f * this.blendMargin);
        return (1.0f - class_3532.method_15362((float)((float)Math.PI * Math.max(0.0f, Math.abs(1.0f - 2.0f * x) * r - r + 1.0f)))) * 0.25f;
    }
}

