/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.hideandseek.core;

import com.eightsidedsquare.hideandseek.common.game.question.Question;
import com.eightsidedsquare.hideandseek.core.ModInit;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_4051;
import net.minecraft.class_6880;
import net.minecraft.class_9283;
import net.minecraft.class_9284;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public interface ModQuestions {
    public static final Question Z_COMPARISON = ModInit.REGISTRY.question("z_comparison", Question.builder().response((player, world, component, source, translationKey) -> {
        String suffix = ModQuestions.comparisonSuffix(player.method_31479(), source.method_31479(), ".south", ".north");
        return class_2561.method_43469((String)(translationKey + suffix), (Object[])new Object[]{player.method_7334().getName(), source.method_31479()});
    }).markingModifier((player, world, ctx, source, x1, z1, x2, z2) -> {
        int seekerZ;
        int hiderZ = player.method_31479();
        if (hiderZ == (seekerZ = source.method_31479())) {
            ctx.mark(x1, z1, x2, seekerZ - 1, true);
            ctx.mark(x1, seekerZ + 1, x2, z2, true);
        } else if (hiderZ > seekerZ) {
            ctx.mark(x1, z1, x2, seekerZ, true);
        } else {
            ctx.mark(x1, seekerZ, x2, z2, true);
        }
    }));
    public static final Question X_COMPARISON = ModInit.REGISTRY.question("x_comparison", Question.builder().response((player, world, component, source, translationKey) -> {
        String suffix = ModQuestions.comparisonSuffix(player.method_31477(), source.method_31477(), ".east", ".west");
        return class_2561.method_43469((String)(translationKey + suffix), (Object[])new Object[]{player.method_7334().getName(), source.method_31477()});
    }).markingModifier((player, world, ctx, source, x1, z1, x2, z2) -> {
        int seekerX;
        int hiderX = player.method_31477();
        if (hiderX == (seekerX = source.method_31477())) {
            ctx.mark(x1, z1, seekerX - 1, z2, true);
            ctx.mark(seekerX + 1, z1, x2, z2, true);
        } else if (hiderX > seekerX) {
            ctx.mark(x1, z1, seekerX, z2, true);
        } else {
            ctx.mark(seekerX, z1, x2, z2, true);
        }
    }));
    public static final Question Y_COMPARISON = ModInit.REGISTRY.question("y_comparison", Question.builder().response((player, world, component, source, translationKey) -> {
        String suffix = ModQuestions.comparisonSuffix(player.method_31478(), source.method_31478(), ".above", ".below");
        return class_2561.method_43469((String)(translationKey + suffix), (Object[])new Object[]{player.method_7334().getName(), source.method_31478()});
    }));
    public static final Question STANDING_ON_SAME_BLOCK_TYPE = ModInit.REGISTRY.question("standing_on_same_block_type", Question.builder().response((player, world, component, source, translationKey) -> {
        class_2680 seekerState = source.method_25936();
        class_2680 hiderState = player.method_25936();
        String suffix = hiderState.method_27852(seekerState.method_26204()) ? ".yes" : ".no";
        return class_2561.method_43469((String)(translationKey + suffix), (Object[])new Object[]{player.method_7334().getName(), seekerState.method_26204().method_9518()});
    }));
    public static final Question IN_SAME_BIOME_TYPE = ModInit.REGISTRY.question("in_same_biome_type", Question.builder().response((player, world, component, source, translationKey) -> {
        class_6880 hiderBiome;
        class_6880 seekerBiome = world.method_23753(source.method_24515());
        String suffix = seekerBiome.equals((Object)(hiderBiome = world.method_23753(player.method_24515()))) ? ".yes" : ".no";
        class_2561 biomeName = (class_2561)seekerBiome.method_40230().map(key -> class_2561.method_43471((String)class_156.method_646((String)"biome", (class_2960)key.method_29177()))).orElse(class_2561.method_43470((String)"?"));
        return class_2561.method_43469((String)(translationKey + suffix), (Object[])new Object[]{player.method_7334().getName(), biomeName});
    }));
    public static final Question NEAR_SAME_MOB_TYPE = ModInit.REGISTRY.question("near_same_mob_type", Question.builder().response((player, world, component, source, translationKey) -> {
        class_1299<?> seekerType = ModQuestions.getNearestMobType(source, 32);
        if (seekerType == null) {
            return class_2561.method_43469((String)(translationKey + ".fail"), (Object[])new Object[]{source.method_7334().getName(), player.method_7334().getName()});
        }
        class_1299<?> hiderType = ModQuestions.getNearestMobType(player, 32);
        String suffix = seekerType.equals(hiderType) ? ".yes" : ".no";
        return class_2561.method_43469((String)(translationKey + suffix), (Object[])new Object[]{player.method_7334().getName(), class_2561.method_43471((String)seekerType.method_5882())});
    }));
    public static final Question DISTANCE_500 = ModInit.REGISTRY.question("distance_500", Question.builder().category(Question.Category.DISTANCE).response(ModQuestions.distance(500)).markingModifier(ModQuestions.distanceMarking(500)));
    public static final Question DISTANCE_250 = ModInit.REGISTRY.question("distance_250", Question.builder().category(Question.Category.DISTANCE).response(ModQuestions.distance(250)).markingModifier(ModQuestions.distanceMarking(250)));
    public static final Question DISTANCE_100 = ModInit.REGISTRY.question("distance_100", Question.builder().category(Question.Category.DISTANCE).response(ModQuestions.distance(100)).markingModifier(ModQuestions.distanceMarking(100)));
    public static final Question DISTANCE_50 = ModInit.REGISTRY.question("distance_50", Question.builder().category(Question.Category.DISTANCE).response(ModQuestions.distance(50)).markingModifier(ModQuestions.distanceMarking(50)));
    public static final Question DISTANCE_25 = ModInit.REGISTRY.question("distance_25", Question.builder().category(Question.Category.DISTANCE).response(ModQuestions.distance(25)).markingModifier(ModQuestions.distanceMarking(25)));
    public static final Question SKY_ABOVE = ModInit.REGISTRY.question("sky_above", Question.builder().category(Question.Category.OBSERVATION).response((player, world, component, source, translationKey) -> {
        String suffix = world.method_8311(class_2338.method_49638((class_2374)player.method_33571())) ? ".yes" : ".no";
        return class_2561.method_43469((String)(translationKey + suffix), (Object[])new Object[]{player.method_7334().getName()});
    }));
    public static final Question IN_STRUCTURE = ModInit.REGISTRY.question("in_structure", Question.builder().category(Question.Category.OBSERVATION).response((player, world, component, source, translationKey) -> {
        String suffix = world.method_27056().method_41413(player.method_24515(), structure -> true).method_16657() ? ".yes" : ".no";
        return class_2561.method_43469((String)(translationKey + suffix), (Object[])new Object[]{player.method_7334().getName()});
    }));
    public static final Question ON_LEAVES = ModInit.REGISTRY.question("on_leaves", Question.builder().category(Question.Category.OBSERVATION).response((player, world, component, source, translationKey) -> {
        String suffix = world.method_8320(player.method_23312().method_10084()).method_27852(class_2246.field_55742) ? ".leaf_litter" : (player.method_25936().method_26164(class_3481.field_15503) ? ".yes" : ".no");
        return class_2561.method_43469((String)(translationKey + suffix), (Object[])new Object[]{player.method_7334().getName()});
    }));
    public static final Question NEAR_WATER = ModInit.REGISTRY.question("near_water", Question.builder().category(Question.Category.OBSERVATION).response((player, world, component, source, translationKey) -> {
        String suffix = ModQuestions.isNear(player, 4, state -> state.method_26227().method_15767(class_3486.field_15517)) ? ".yes" : ".no";
        return class_2561.method_43469((String)(translationKey + suffix), (Object[])new Object[]{player.method_7334().getName()});
    }));
    public static final Question NEAR_LAVA = ModInit.REGISTRY.question("near_lava", Question.builder().category(Question.Category.OBSERVATION).response((player, world, component, source, translationKey) -> {
        String suffix = ModQuestions.isNear(player, 4, state -> state.method_26227().method_15767(class_3486.field_15518)) ? ".yes" : ".no";
        return class_2561.method_43469((String)(translationKey + suffix), (Object[])new Object[]{player.method_7334().getName()});
    }));
    public static final Question NEAR_SNOW = ModInit.REGISTRY.question("near_snow", Question.builder().category(Question.Category.OBSERVATION).response((player, world, component, source, translationKey) -> {
        String suffix = ModQuestions.isNear(player, 4, state -> state.method_26164(class_3481.field_29823)) ? ".yes" : ".no";
        return class_2561.method_43469((String)(translationKey + suffix), (Object[])new Object[]{player.method_7334().getName()});
    }));
    public static final Question NEAR_FLOWER = ModInit.REGISTRY.question("near_flower", Question.builder().category(Question.Category.OBSERVATION).response((player, world, component, source, translationKey) -> {
        String suffix = ModQuestions.isNear(player, 4, state -> state.method_26164(class_3481.field_20339)) ? ".yes" : ".no";
        return class_2561.method_43469((String)(translationKey + suffix), (Object[])new Object[]{player.method_7334().getName()});
    }));
    public static final Question IN_BLOCK_LIGHT = ModInit.REGISTRY.question("in_block_light", Question.builder().category(Question.Category.OBSERVATION).response((player, world, component, source, translationKey) -> {
        String suffix = world.method_8314(class_1944.field_9282, player.method_24515()) > 0 ? ".yes" : ".no";
        return class_2561.method_43469((String)(translationKey + suffix), (Object[])new Object[]{player.method_7334().getName()});
    }));
    public static final Question BREAK_BLOCK = ModInit.REGISTRY.question("break_block", Question.builder().category(Question.Category.TASK).trigger(Question.ResponseTrigger.BREAK_BLOCK).response(ModQuestions.success()));
    public static final Question PLACE_GRASS_BLOCK = ModInit.REGISTRY.question("place_grass_block", Question.builder().category(Question.Category.TASK).hiderModifier(ModQuestions.offhandItem(class_1802.field_8270)).trigger(Question.ResponseTrigger.PLACE_BLOCK).response(ModQuestions.success()));
    public static final Question PLACE_STONE = ModInit.REGISTRY.question("place_stone", Question.builder().category(Question.Category.TASK).hiderModifier(ModQuestions.offhandItem(class_1802.field_20391)).trigger(Question.ResponseTrigger.PLACE_BLOCK).response(ModQuestions.success()));
    public static final Question PLACE_SAND = ModInit.REGISTRY.question("place_sand", Question.builder().category(Question.Category.TASK).hiderModifier(ModQuestions.offhandItem(class_1802.field_8858)).trigger(Question.ResponseTrigger.PLACE_BLOCK).response(ModQuestions.success()));
    public static final Question PLACE_GRAVEL = ModInit.REGISTRY.question("place_gravel", Question.builder().category(Question.Category.TASK).hiderModifier(ModQuestions.offhandItem(class_1802.field_8110)).trigger(Question.ResponseTrigger.PLACE_BLOCK).response(ModQuestions.success()));
    public static final Question USE_FIRE_CHARGE = ModInit.REGISTRY.question("use_fire_charge", Question.builder().category(Question.Category.TASK).hiderModifier(ModQuestions.offhandItem(class_1802.field_8814)).trigger(Question.ResponseTrigger.USE_ITEM).response(ModQuestions.success()));
    public static final Question USE_FIREWORK_ROCKET = ModInit.REGISTRY.question("use_firework_rocket", Question.builder().category(Question.Category.TASK).hiderModifier(ModQuestions.offhandItem(() -> {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8639);
        stack.method_57379(class_9334.field_49616, (Object)new class_9284(1, List.of(new class_9283(class_9283.class_1782.field_7976, IntList.of((int)-65536), IntList.of(), false, false))));
        return stack;
    })).trigger(Question.ResponseTrigger.USE_ITEM).response(ModQuestions.success()));
    public static final Question SPAWN_BEE = ModInit.REGISTRY.question("spawn_bee", Question.builder().category(Question.Category.TASK).hiderModifier(ModQuestions.offhandItem(class_1802.field_20413)).trigger(Question.ResponseTrigger.USE_ITEM).response(ModQuestions.success()));
    public static final Question SPAWN_CHICKEN = ModInit.REGISTRY.question("spawn_chicken", Question.builder().category(Question.Category.TASK).hiderModifier(ModQuestions.offhandItem(class_1802.field_8835)).trigger(Question.ResponseTrigger.USE_ITEM).response(ModQuestions.success()));
    public static final Question SPAWN_COW = ModInit.REGISTRY.question("spawn_cow", Question.builder().category(Question.Category.TASK).hiderModifier(ModQuestions.offhandItem(class_1802.field_8433)).trigger(Question.ResponseTrigger.USE_ITEM).response(ModQuestions.success()));
    public static final Question SPAWN_PIG = ModInit.REGISTRY.question("spawn_pig", Question.builder().category(Question.Category.TASK).hiderModifier(ModQuestions.offhandItem(class_1802.field_8493)).trigger(Question.ResponseTrigger.USE_ITEM).response(ModQuestions.success()));
    public static final Question SPAWN_RABBIT = ModInit.REGISTRY.question("spawn_rabbit", Question.builder().category(Question.Category.TASK).hiderModifier(ModQuestions.offhandItem(class_1802.field_8227)).trigger(Question.ResponseTrigger.USE_ITEM).response(ModQuestions.success()));

    public static void init() {
    }

    private static boolean isNear(class_3222 player, int range, Predicate<class_2680> predicate) {
        Iterable iterable = class_2338.method_10094((int)(player.method_31477() - range), (int)(player.method_31478() - range), (int)(player.method_31479() - range), (int)(player.method_31477() + range), (int)(player.method_31478() + range), (int)(player.method_31479() + range));
        for (class_2338 pos : iterable) {
            if (!predicate.test(player.method_51469().method_8320(pos))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static class_1299<?> getNearestMobType(class_3222 player, int range) {
        class_4051 predicate = class_4051.method_36626().method_36627();
        class_1308 closestEntity = (class_1308)player.method_51469().method_64391(class_1308.class, predicate, (class_1309)player, player.method_23317(), player.method_23318(), player.method_23321(), player.method_5829().method_1014((double)range));
        return closestEntity == null ? null : closestEntity.method_5864();
    }

    private static Question.HiderModifier offhandItem(class_1792 item) {
        return (player, world, component) -> player.method_6122(class_1268.field_5810, new class_1799((class_1935)item));
    }

    private static Question.HiderModifier offhandItem(Supplier<class_1799> stackSupplier) {
        return (player, world, component) -> player.method_6122(class_1268.field_5810, (class_1799)stackSupplier.get());
    }

    private static Question.Response success() {
        return (player, world, component, source, translationKey) -> class_2561.method_43469((String)(translationKey + ".success"), (Object[])new Object[]{player.method_7334().getName()});
    }

    private static Question.Response distance(int radius) {
        return (player, world, component, source, translationKey) -> {
            int dZ;
            int dX = source.method_31477() - player.method_31477();
            String suffix = Math.sqrt(dX * dX + (dZ = source.method_31479() - player.method_31479()) * dZ) <= (double)radius ? ".yes" : ".no";
            return class_2561.method_43469((String)(translationKey + suffix), (Object[])new Object[]{player.method_7334().getName(), source.method_31477(), source.method_31479()});
        };
    }

    private static Question.MarkingModifier distanceMarking(int radius) {
        return (player, world, ctx, source, x1, z1, x2, z2) -> {
            int dZ;
            int dX = source.method_31477() - player.method_31477();
            if (Math.sqrt(dX * dX + (dZ = source.method_31479() - player.method_31479()) * dZ) <= (double)radius) {
                ctx.markInverted(source.method_31477(), source.method_31479(), radius, true);
            } else {
                ctx.mark(source.method_31477(), source.method_31479(), radius, true);
            }
        };
    }

    private static String comparisonSuffix(int hider, int seeker, String above, String below) {
        return hider == seeker ? ".exact" : (hider > seeker ? above : below);
    }
}

