/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.hideandseek.core;

import com.eightsidedsquare.hideandseek.common.cca.GameComponent;
import com.eightsidedsquare.hideandseek.common.cca.WorldMarkingComponent;
import com.eightsidedsquare.hideandseek.common.network.ActiveQuestionS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.AnnouncementS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.AskQuestionC2SPayload;
import com.eightsidedsquare.hideandseek.common.network.ChallengeStatusS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.ClearWorldMarkingsS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.CluesS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.EndResultsS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.GamePlayerListS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.HiderAnnouncementS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.HiderStatusS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.HidingSpotRequirementsS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.HidingTimeS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.MarkWorldC2SPayload;
import com.eightsidedsquare.hideandseek.common.network.PickPowerupsC2SPayload;
import com.eightsidedsquare.hideandseek.common.network.PlayPowerupC2SPayload;
import com.eightsidedsquare.hideandseek.common.network.PowerupRewardS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.QuestionStatesS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.QueueC2SPayload;
import com.eightsidedsquare.hideandseek.common.network.ResetGameS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.SeekerQuestionCooldownS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.SeekerTpCooldownS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.StartC2SPayload;
import com.eightsidedsquare.hideandseek.common.network.SubmitHidingSpotC2SPayload;
import com.eightsidedsquare.hideandseek.common.network.SyncGameStateS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.SyncPowerupsS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.TeleportC2SPayload;
import com.eightsidedsquare.hideandseek.common.network.WorldMarkingChangesS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.WorldMarkingsS2CPayload;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_9129;

public interface ModNetworking {
    public static void init() {
        ModNetworking.registerS2C((PayloadTypeRegistry<class_9129>)PayloadTypeRegistry.playS2C());
        ModNetworking.registerC2S((PayloadTypeRegistry<class_9129>)PayloadTypeRegistry.playC2S());
        ModNetworking.registerServerReceivers();
    }

    private static void registerS2C(PayloadTypeRegistry<class_9129> registry) {
        registry.register(ActiveQuestionS2CPayload.ID, ActiveQuestionS2CPayload.CODEC);
        registry.register(AnnouncementS2CPayload.ID, AnnouncementS2CPayload.CODEC);
        registry.register(ChallengeStatusS2CPayload.ID, ChallengeStatusS2CPayload.CODEC);
        registry.register(ClearWorldMarkingsS2CPayload.ID, ClearWorldMarkingsS2CPayload.CODEC);
        registry.register(CluesS2CPayload.ID, CluesS2CPayload.CODEC);
        registry.register(EndResultsS2CPayload.ID, EndResultsS2CPayload.CODEC);
        registry.register(GamePlayerListS2CPayload.ID, GamePlayerListS2CPayload.CODEC);
        registry.register(HiderAnnouncementS2CPayload.ID, HiderAnnouncementS2CPayload.CODEC);
        registry.register(HiderStatusS2CPayload.ID, HiderStatusS2CPayload.CODEC);
        registry.register(HidingSpotRequirementsS2CPayload.ID, HidingSpotRequirementsS2CPayload.CODEC);
        registry.register(HidingTimeS2CPayload.ID, HidingTimeS2CPayload.CODEC);
        registry.register(PowerupRewardS2CPayload.ID, PowerupRewardS2CPayload.CODEC);
        registry.register(QuestionStatesS2CPayload.ID, QuestionStatesS2CPayload.CODEC);
        registry.register(ResetGameS2CPayload.ID, ResetGameS2CPayload.CODEC);
        registry.register(SeekerQuestionCooldownS2CPayload.ID, SeekerQuestionCooldownS2CPayload.CODEC);
        registry.register(SeekerTpCooldownS2CPayload.ID, SeekerTpCooldownS2CPayload.CODEC);
        registry.register(SyncGameStateS2CPayload.ID, SyncGameStateS2CPayload.CODEC);
        registry.register(SyncPowerupsS2CPayload.ID, SyncPowerupsS2CPayload.CODEC);
        registry.register(WorldMarkingsS2CPayload.ID, WorldMarkingsS2CPayload.CODEC);
        registry.register(WorldMarkingChangesS2CPayload.ID, WorldMarkingChangesS2CPayload.CODEC);
    }

    private static void registerC2S(PayloadTypeRegistry<class_9129> registry) {
        registry.register(AskQuestionC2SPayload.ID, AskQuestionC2SPayload.CODEC);
        registry.register(QueueC2SPayload.ID, QueueC2SPayload.CODEC);
        registry.register(MarkWorldC2SPayload.ID, MarkWorldC2SPayload.CODEC);
        registry.register(PickPowerupsC2SPayload.ID, PickPowerupsC2SPayload.CODEC);
        registry.register(PlayPowerupC2SPayload.ID, PlayPowerupC2SPayload.CODEC);
        registry.register(StartC2SPayload.ID, StartC2SPayload.CODEC);
        registry.register(SubmitHidingSpotC2SPayload.ID, SubmitHidingSpotC2SPayload.CODEC);
        registry.register(TeleportC2SPayload.ID, TeleportC2SPayload.CODEC);
    }

    public static void registerServerReceivers() {
        ServerPlayNetworking.registerGlobalReceiver(AskQuestionC2SPayload.ID, (payload, ctx) -> {
            GameComponent component = GameComponent.get((class_1937)ctx.player().method_51469());
            if (component != null) {
                component.askQuestion(ctx.player(), payload.question());
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(TeleportC2SPayload.ID, (payload, ctx) -> {
            GameComponent component = GameComponent.get((class_1937)ctx.player().method_51469());
            if (component != null) {
                if (payload.hider()) {
                    component.tryTeleportHider(ctx.player(), payload.x(), payload.z());
                } else {
                    component.tryTeleportSeekers(ctx.player(), payload.x(), payload.z());
                }
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(QueueC2SPayload.ID, (payload, ctx) -> {
            GameComponent component = GameComponent.get((class_1937)ctx.player().method_51469());
            if (component != null && component.isQueueingPhase()) {
                if (payload.joining()) {
                    component.addPlayers(List.of(ctx.player()));
                } else {
                    component.removePlayers(List.of(ctx.player()));
                }
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(MarkWorldC2SPayload.ID, (payload, ctx) -> {
            WorldMarkingComponent worldMarkingComponent;
            class_3218 world = ctx.player().method_51469();
            GameComponent component = GameComponent.get((class_1937)world);
            if (component != null && component.isSeeker((class_1657)ctx.player()) && component.isSeekingPhase() && (worldMarkingComponent = WorldMarkingComponent.get((class_1937)world)) != null) {
                worldMarkingComponent.mark(payload.x1(), payload.z1(), payload.x2(), payload.z2(), payload.value());
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(PickPowerupsC2SPayload.ID, (payload, ctx) -> {
            GameComponent component = GameComponent.get((class_1937)ctx.player().method_51469());
            if (component != null) {
                component.pickPowerups(ctx.player(), payload.picked(), payload.discarded());
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(PlayPowerupC2SPayload.ID, (payload, ctx) -> {
            GameComponent component = GameComponent.get((class_1937)ctx.player().method_51469());
            if (component != null) {
                component.playPowerup(ctx.player(), payload.powerup());
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(StartC2SPayload.ID, (payload, ctx) -> {
            GameComponent component = GameComponent.get((class_1937)ctx.player().method_51469());
            if (component != null) {
                component.tryStarting();
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(SubmitHidingSpotC2SPayload.ID, (payload, ctx) -> {
            GameComponent component = GameComponent.get((class_1937)ctx.player().method_51469());
            if (component != null && component.isHider((class_1657)ctx.player())) {
                component.tryAcceptingHidingSpot(ctx.player());
            }
        });
    }
}

