/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.hideandseek.common.network;

import com.eightsidedsquare.hideandseek.common.cca.GameComponent;
import com.eightsidedsquare.hideandseek.common.game.player.GamePlayer;
import com.eightsidedsquare.hideandseek.common.game.player.GamePlayerManagerImpl;
import com.eightsidedsquare.hideandseek.common.game.player.ServerGamePlayer;
import com.eightsidedsquare.hideandseek.core.ModInit;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_4844;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public record EndResultsS2CPayload(int delay, Entry first, Entry second, Optional<Entry> third) implements class_8710
{
    public static final class_8710.class_9154<EndResultsS2CPayload> ID = new class_8710.class_9154(ModInit.id("end_results"));
    public static final class_9139<ByteBuf, EndResultsS2CPayload> CODEC = class_9139.method_56905((class_9139)class_9135.field_48550, EndResultsS2CPayload::delay, Entry.CODEC, EndResultsS2CPayload::first, Entry.CODEC, EndResultsS2CPayload::second, (class_9139)Entry.CODEC.method_56433(class_9135::method_56382), EndResultsS2CPayload::third, EndResultsS2CPayload::new);

    @Nullable
    public static EndResultsS2CPayload create(int delay, GameComponent component) {
        ObjectArrayList list = new ObjectArrayList(((GamePlayerManagerImpl)component.getPlayerManager()).players);
        if (list.size() < 2) {
            return null;
        }
        list.sort(GamePlayer::compareTo);
        ServerGamePlayer first = (ServerGamePlayer)list.getFirst();
        ServerGamePlayer second = (ServerGamePlayer)list.get(1);
        ServerGamePlayer third = list.size() < 3 ? null : (ServerGamePlayer)list.get(2);
        return new EndResultsS2CPayload(delay, new Entry(first, component), new Entry(second, component), Optional.ofNullable(third == null ? null : new Entry(third, component)));
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return ID;
    }

    public record Entry(UUID uuid, int time) {
        public static final class_9139<ByteBuf, Entry> CODEC = class_9139.method_56435((class_9139)class_4844.field_48453, Entry::uuid, (class_9139)class_9135.field_48550, Entry::time, Entry::new);

        public Entry(ServerGamePlayer gamePlayer, GameComponent component) {
            this(gamePlayer.getUuid(), gamePlayer.getHidingTime() + Entry.getBonusTime(gamePlayer, component));
        }

        private static int getBonusTime(ServerGamePlayer gamePlayer, GameComponent component) {
            if (component.getBonusTime() != null && component.getBonusTime().getHider().equals(gamePlayer.getUuid())) {
                return component.getBonusTime().getTime();
            }
            return 0;
        }
    }
}

