/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.hideandseek.common.game.state;

import com.eightsidedsquare.hideandseek.common.game.player.ServerGamePlayer;
import com.eightsidedsquare.hideandseek.common.game.state.GameDimensions;
import com.eightsidedsquare.hideandseek.common.game.state.GameStateImpl;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3542;
import net.minecraft.class_4076;
import net.minecraft.class_7995;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public interface GameState {
    public static final Codec<GameState> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GameDimensions.CODEC.optionalFieldOf("dimensions").forGetter(state -> Optional.ofNullable(state.getDimensions())), (App)Phase.CODEC.optionalFieldOf("phase", (Object)Phase.QUEUEING).forGetter(GameState::getPhase)).apply((Applicative)instance, GameStateImpl::new));
    public static final class_9139<class_9129, GameState> PACKET_CODEC = class_9139.method_56435((class_9139)GameDimensions.PACKET_CODEC.method_56433(class_9135::method_56382), state -> Optional.ofNullable(state.getDimensions()), Phase.PACKET_CODEC, GameState::getPhase, GameStateImpl::new);

    @Nullable
    public GameDimensions getDimensions();

    public void setDimensions(@Nullable GameDimensions var1);

    public Phase getPhase();

    public void setPhase(Phase var1);

    default public boolean isQueueingPhase() {
        return this.getPhase() == Phase.QUEUEING;
    }

    default public boolean isHidingPhase() {
        return this.getPhase() == Phase.HIDING;
    }

    default public boolean isSeekingPhase() {
        return this.getPhase() == Phase.SEEKING;
    }

    default public boolean isIntermissionPhase() {
        return this.getPhase() == Phase.INTERMISSION;
    }

    default public boolean isEndPhase() {
        return this.getPhase() == Phase.END;
    }

    default public void calculateDimensions(class_3218 world, List<ServerGamePlayer> players, int chunkWidth) {
        int sumX = 0;
        int sumZ = 0;
        int count = 0;
        for (ServerGamePlayer gamePlayer : players) {
            class_3222 player = (class_3222)gamePlayer.getPlayer(world);
            if (player == null) continue;
            class_2338 pos = player.method_24515();
            sumX += pos.method_10263();
            sumZ += pos.method_10260();
            ++count;
        }
        int biomeX = class_4076.method_18675((int)(sumX / count));
        int biomeZ = class_4076.method_18675((int)(sumZ / count));
        int x = class_4076.method_18688((int)(biomeX - chunkWidth / 2));
        int z = class_4076.method_18688((int)(biomeZ - chunkWidth / 2));
        this.setDimensions(new GameDimensions(x, z, class_4076.method_18688((int)chunkWidth)));
    }

    public static enum Phase implements class_3542
    {
        QUEUEING("queueing"),
        INTERMISSION("intermission"),
        HIDING("hiding"),
        SEEKING("seeking"),
        END("end");

        public static final IntFunction<Phase> INDEX_TO_VALUE;
        public static final class_9139<ByteBuf, Phase> PACKET_CODEC;
        public static final Codec<Phase> CODEC;
        private final String name;

        private Phase(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        static {
            INDEX_TO_VALUE = class_7995.method_47914(Enum::ordinal, (Object[])Phase.values(), (class_7995.class_7996)class_7995.class_7996.field_41664);
            PACKET_CODEC = class_9135.method_56375(INDEX_TO_VALUE, Enum::ordinal);
            CODEC = class_3542.method_28140(Phase::values);
        }
    }
}

