/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.hideandseek.common.game.question;

import com.eightsidedsquare.hideandseek.common.cca.GameComponent;
import com.eightsidedsquare.hideandseek.common.cca.WorldMarkingComponent;
import com.eightsidedsquare.hideandseek.common.game.marking.WorldMarkingContext;
import com.eightsidedsquare.hideandseek.common.game.marking.WorldMarkingData;
import com.eightsidedsquare.hideandseek.core.ModCriteria;
import com.eightsidedsquare.hideandseek.core.ModInit;
import java.util.Objects;
import net.minecraft.class_174;
import net.minecraft.class_179;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4076;
import org.jetbrains.annotations.Nullable;

public class Question {
    private final String translationKey;
    private final class_2960 texture;
    @Nullable
    private final HiderModifier hiderModifier;
    @Nullable
    private final MarkingModifier markingModifier;
    private final Response response;
    private final ResponseTrigger responseTrigger;
    private final Category category;

    public Question(String translationKey, class_2960 texture, @Nullable HiderModifier hiderModifier, @Nullable MarkingModifier markingModifier, Response response, ResponseTrigger responseTrigger, Category category) {
        this.translationKey = translationKey;
        this.texture = texture;
        this.hiderModifier = hiderModifier;
        this.markingModifier = markingModifier;
        this.response = response;
        this.responseTrigger = responseTrigger;
        this.category = category;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public class_2960 getTexture() {
        return this.texture;
    }

    public Category getCategory() {
        return this.category;
    }

    public ResponseTrigger getResponseTrigger() {
        return this.responseTrigger;
    }

    public boolean triggersAutomatically() {
        return this.getResponseTrigger() == ResponseTrigger.AUTOMATIC;
    }

    public void applyHiderModifier(class_3222 player, GameComponent component) {
        if (this.hiderModifier != null) {
            this.hiderModifier.apply(player, player.method_51469(), component);
        }
    }

    public class_2561 getResponse(class_3222 player, GameComponent component, class_3222 source) {
        return this.response.apply(player, player.method_51469(), component, source, this.getTranslationKey());
    }

    public void applyMarkingModifier(class_3222 player, WorldMarkingComponent component, class_3222 source) {
        WorldMarkingData data;
        if (this.markingModifier != null && (data = component.getData()) != null) {
            int size = class_4076.method_18688((int)data.getSize());
            int x1 = data.getOrigin().method_8326();
            int x2 = x1 + size - 1;
            int z1 = data.getOrigin().method_8328();
            int z2 = z1 + size - 1;
            this.markingModifier.apply(player, player.method_51469(), component.getQueue(), source, x1, z1, x2, z2);
        }
    }

    @FunctionalInterface
    public static interface HiderModifier {
        public void apply(class_3222 var1, class_3218 var2, GameComponent var3);
    }

    @FunctionalInterface
    public static interface MarkingModifier {
        public void apply(class_3222 var1, class_3218 var2, WorldMarkingContext var3, class_3222 var4, int var5, int var6, int var7, int var8);
    }

    @FunctionalInterface
    public static interface Response {
        public class_2561 apply(class_3222 var1, class_3218 var2, GameComponent var3, class_3222 var4, String var5);
    }

    public static enum ResponseTrigger {
        AUTOMATIC,
        PLACE_BLOCK,
        BREAK_BLOCK,
        USE_ITEM;


        public boolean accepts(class_179<?> criterion) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> false;
                case 1 -> criterion.equals((Object)class_174.field_1191);
                case 2 -> criterion.equals((Object)ModCriteria.BLOCK_BROKEN);
                case 3 -> criterion.equals((Object)class_174.field_24478) || criterion.equals((Object)class_174.field_33872);
            };
        }
    }

    public static enum Category {
        COMPARING("comparing", 3, 2, -5227826),
        DISTANCE("distance", 2, 2, -12941362),
        OBSERVATION("observation", 2, 1, -12923301),
        TASK("task", 1, 1, -2697659);

        private final String translationKey;
        private final class_2960 texture;
        private final class_2960 highlightedTexture;
        private final class_2960 disabledTexture;
        private final int draw;
        private final int pick;
        private final int color;

        private Category(String name, int draw, int pick, int color) {
            this.translationKey = "question.category." + name;
            this.texture = ModInit.id("question/button/" + name);
            this.highlightedTexture = this.texture.method_48331("_highlighted");
            this.disabledTexture = this.texture.method_48331("_disabled");
            this.draw = draw;
            this.pick = pick;
            this.color = color;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public class_2960 getTexture() {
            return this.texture;
        }

        public class_2960 getHighlightedTexture() {
            return this.highlightedTexture;
        }

        public class_2960 getDisabledTexture() {
            return this.disabledTexture;
        }

        public class_2960 getTexture(int timesAsked, boolean active, boolean selected) {
            if (!active) {
                return this.getDisabledTexture();
            }
            if (selected) {
                return this.getHighlightedTexture();
            }
            if (timesAsked > 0) {
                return this.getDisabledTexture();
            }
            return this.getTexture();
        }

        public int getDrawCount() {
            return this.draw;
        }

        public int getPickCount() {
            return this.pick;
        }

        public int getColor() {
            return this.color;
        }

        public class_2561 getRewardText() {
            return class_2561.method_43469((String)"question.category.reward", (Object[])new Object[]{this.getDrawCount(), this.getPickCount()});
        }
    }

    public static class Builder {
        private String translationKey;
        private class_2960 texture;
        @Nullable
        private HiderModifier hiderModifier;
        @Nullable
        private MarkingModifier markingModifier;
        private Response response;
        private ResponseTrigger responseTrigger = ResponseTrigger.AUTOMATIC;
        private Category category = Category.COMPARING;

        private Builder() {
        }

        public Builder translationKey(String translationKey) {
            this.translationKey = translationKey;
            return this;
        }

        public Builder texture(class_2960 texture) {
            this.texture = texture;
            return this;
        }

        public Builder hiderModifier(@Nullable HiderModifier hiderModifier) {
            this.hiderModifier = hiderModifier;
            return this;
        }

        public Builder markingModifier(@Nullable MarkingModifier markingModifier) {
            this.markingModifier = markingModifier;
            return this;
        }

        public Builder response(Response response) {
            this.response = response;
            return this;
        }

        public Builder trigger(ResponseTrigger responseTrigger) {
            this.responseTrigger = responseTrigger;
            return this;
        }

        public Builder category(Category category) {
            this.category = category;
            return this;
        }

        public Question build() {
            Objects.requireNonNull(this.translationKey);
            Objects.requireNonNull(this.texture);
            Objects.requireNonNull(this.response);
            return new Question(this.translationKey, this.texture, this.hiderModifier, this.markingModifier, this.response, this.responseTrigger, this.category);
        }
    }
}

