/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.hideandseek.common.game.question;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.class_2561;
import net.minecraft.class_5481;
import net.minecraft.class_8824;

public class Clues {
    public static final Codec<Clues> CODEC = class_8824.field_46597.listOf().xmap(Clues::new, Clues::getClues);
    private final List<class_2561> clues;

    public Clues(List<class_2561> clues) {
        this.clues = new ObjectArrayList(clues);
    }

    public Clues() {
        this.clues = new ObjectArrayList();
    }

    public List<class_2561> getClues() {
        return this.clues;
    }

    public void addClue(class_2561 clue) {
        this.getClues().add(clue);
    }

    public void addClues(List<class_2561> clues) {
        this.getClues().addAll(clues);
    }

    public void clear() {
        this.getClues().clear();
    }

    public List<Page> getPages(BiFunction<class_2561, Integer, List<class_5481>> wrappedLineGetter, int maxWidth, int maxHeight, int margin) {
        if (this.isEmpty()) {
            return List.of();
        }
        ObjectArrayList pages = new ObjectArrayList();
        Page page = new Page();
        pages.add(page);
        int height = 0;
        for (class_2561 clue : this.clues) {
            Entry entry = new Entry(wrappedLineGetter.apply(clue, maxWidth));
            int entryHeight = entry.lines.size() * 9;
            if (height + entryHeight > maxHeight) {
                page = new Page();
                pages.add(page);
                height = 0;
            }
            height += entryHeight + margin;
            page.entries.add(entry);
        }
        return pages;
    }

    public boolean isEmpty() {
        return this.clues.isEmpty();
    }

    public record Page(List<Entry> entries) {
        public Page() {
            this((List<Entry>)new ObjectArrayList());
        }

        public void forEach(int margin, PageConsumer consumer) {
            int y = 0;
            for (Entry entry : this.entries) {
                for (int i = 0; i < entry.lines.size(); ++i) {
                    consumer.accept(entry.lines.get(i), y, i == 0);
                    y += 9;
                }
                y += margin;
            }
        }
    }

    public record Entry(List<class_5481> lines) {
    }

    @FunctionalInterface
    public static interface PageConsumer {
        public void accept(class_5481 var1, int var2, boolean var3);
    }
}

