/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.hideandseek.common.game.question;

import com.eightsidedsquare.hideandseek.common.game.question.Question;
import com.eightsidedsquare.hideandseek.core.ModRegistries;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_5699;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class ActiveQuestion {
    public static final Codec<ActiveQuestion> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ModRegistries.QUESTION.method_39673().fieldOf("question").forGetter(ActiveQuestion::getQuestion), (App)class_5699.field_33441.optionalFieldOf("outbound_ticks", (Object)0).forGetter(ActiveQuestion::getOutboundTicks), (App)class_5699.field_33441.optionalFieldOf("inbound_ticks", (Object)0).forGetter(ActiveQuestion::getInboundTicks), (App)Codec.BOOL.optionalFieldOf("waiting", (Object)false).forGetter(ActiveQuestion::isWaiting), (App)Codec.BOOL.optionalFieldOf("canceled", (Object)false).forGetter(ActiveQuestion::isCanceled)).apply((Applicative)instance, ActiveQuestion::new));
    public static final class_9139<class_9129, ActiveQuestion> PACKET_CODEC = class_9139.method_56906((class_9139)class_9135.method_56365(ModRegistries.QUESTION_KEY), ActiveQuestion::getQuestion, (class_9139)class_9135.field_48550, ActiveQuestion::getOutboundTicks, (class_9139)class_9135.field_48550, ActiveQuestion::getInboundTicks, (class_9139)class_9135.field_48547, ActiveQuestion::isWaiting, (class_9139)class_9135.field_48547, ActiveQuestion::isCanceled, ActiveQuestion::new);
    private final Question question;
    private int outboundTicks;
    private int inboundTicks;
    private boolean waiting;
    private boolean canceled;

    public ActiveQuestion(Question question, int outboundTicks, int inboundTicks, boolean waiting, boolean canceled) {
        this.question = question;
        this.outboundTicks = outboundTicks;
        this.inboundTicks = inboundTicks;
        this.waiting = waiting;
        this.canceled = canceled;
    }

    public ActiveQuestion(Question question, boolean canceled) {
        this(question, 40, 40, !question.triggersAutomatically(), canceled);
    }

    public Question getQuestion() {
        return this.question;
    }

    public int getOutboundTicks() {
        return this.outboundTicks;
    }

    public int getInboundTicks() {
        return this.inboundTicks;
    }

    public boolean isWaiting() {
        return this.waiting;
    }

    public void setWaiting(boolean waiting) {
        this.waiting = waiting;
    }

    public boolean isWaitingNow() {
        return this.isWaiting() && this.outboundTicks == 0;
    }

    public boolean isOutbound() {
        return this.outboundTicks > 0;
    }

    public boolean isInbound() {
        return !this.isWaiting() && this.inboundTicks > 0 && this.outboundTicks == 0;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public boolean tick() {
        if (this.outboundTicks > 0) {
            --this.outboundTicks;
            return false;
        }
        if (this.canceled) {
            return true;
        }
        if (this.waiting) {
            return false;
        }
        if (this.inboundTicks > 0) {
            --this.inboundTicks;
            return false;
        }
        return true;
    }
}

