/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.hideandseek.common.game.powerup;

import com.eightsidedsquare.hideandseek.common.cca.GameComponent;
import com.eightsidedsquare.hideandseek.common.game.powerup.Powerup;
import com.eightsidedsquare.hideandseek.common.game.powerup.PowerupReward;
import com.eightsidedsquare.hideandseek.common.game.powerup.TimeBonusPowerup;
import com.eightsidedsquare.hideandseek.core.ModRegistries;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_3218;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class PowerupHand {
    public static final int MAX_HAND_SIZE = 5;
    public static final Codec<PowerupHand> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ModRegistries.POWERUP.method_39673().listOf().optionalFieldOf("hand", List.of()).forGetter(PowerupHand::getHand), (App)PowerupReward.CODEC.listOf().optionalFieldOf("rewards", List.of()).forGetter(PowerupHand::getRewardQueue)).apply((Applicative)instance, PowerupHand::new));
    public static final class_9139<class_9129, PowerupHand> PACKET_CODEC = class_9139.method_56435((class_9139)class_9135.method_56365(ModRegistries.POWERUP_KEY).method_56433(class_9135.method_56363()), PowerupHand::getHand, (class_9139)PowerupReward.PACKET_CODEC.method_56433(class_9135.method_56363()), PowerupHand::getRewardQueue, PowerupHand::new);
    private final List<Powerup> hand;
    private final List<PowerupReward> rewardQueue;

    public PowerupHand(List<Powerup> hand, List<PowerupReward> rewardQueue) {
        this.hand = new ObjectArrayList(hand);
        this.rewardQueue = new ObjectArrayList(rewardQueue);
    }

    public PowerupHand() {
        this.hand = new ObjectArrayList();
        this.rewardQueue = new ObjectArrayList();
    }

    public void clear() {
        this.hand.clear();
        this.rewardQueue.clear();
    }

    public List<Powerup> getHand() {
        return this.hand;
    }

    public List<PowerupReward> getRewardQueue() {
        return this.rewardQueue;
    }

    public int getTimeBonus() {
        int bonus = 0;
        for (Powerup powerup : this.hand) {
            if (!(powerup instanceof TimeBonusPowerup)) continue;
            TimeBonusPowerup timeBonusPowerup = (TimeBonusPowerup)powerup;
            bonus += timeBonusPowerup.time();
        }
        return bonus;
    }

    public boolean play(Powerup powerup, class_3218 world, GameComponent component) {
        if (powerup.isPlayable() && this.hand.remove(powerup)) {
            powerup.play(world, component);
            return true;
        }
        return false;
    }

    public boolean pick(List<Powerup> picked, List<Powerup> discarded) {
        if (this.rewardQueue.isEmpty()) {
            return false;
        }
        if (this.hand.size() - discarded.size() < 0) {
            return false;
        }
        if (this.hand.size() - discarded.size() + picked.size() > 5) {
            return false;
        }
        PowerupReward powerupReward = this.rewardQueue.getFirst();
        if (picked.size() != powerupReward.pickCount()) {
            return false;
        }
        ObjectArrayList reward = new ObjectArrayList(powerupReward.powerups());
        ObjectArrayList backupHand = new ObjectArrayList(this.hand);
        Runnable restore = () -> this.lambda$pick$1((List)backupHand);
        for (Powerup powerup : discarded) {
            if (this.hand.remove(powerup)) continue;
            restore.run();
            return false;
        }
        for (Powerup powerup : picked) {
            if (!reward.remove(powerup)) {
                restore.run();
                return false;
            }
            this.hand.add(powerup);
        }
        if (this.hand.size() > 5) {
            restore.run();
            return false;
        }
        this.rewardQueue.removeFirst();
        return true;
    }

    private /* synthetic */ void lambda$pick$1(List backupHand) {
        this.hand.clear();
        this.hand.addAll(backupHand);
    }
}

