/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.hideandseek.common.game.player;

import com.eightsidedsquare.hideandseek.common.game.player.GamePlayer;
import com.eightsidedsquare.hideandseek.common.game.player.GamePlayerManager;
import com.eightsidedsquare.hideandseek.common.network.GamePlayerListS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.HiderStatusS2CPayload;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntUnaryOperator;
import net.minecraft.class_1657;
import net.minecraft.class_4844;
import org.jetbrains.annotations.Nullable;

public class GamePlayerManagerImpl<P extends GamePlayer<?, ?>>
implements GamePlayerManager<P> {
    public final List<P> players = new ObjectArrayList();
    public final Map<UUID, P> uuidToPlayer = new Object2ObjectOpenHashMap();
    public boolean tickHiderTime = false;
    @Nullable
    public P hider;

    public GamePlayerManagerImpl() {
    }

    private GamePlayerManagerImpl(List<P> players, boolean tickHiderTime, Optional<UUID> hider) {
        this.players.addAll(players);
        this.players.forEach(player -> this.uuidToPlayer.put(player.getUuid(), player));
        this.tickHiderTime = tickHiderTime;
        this.hider = hider.map(this.uuidToPlayer::get).orElse(null);
    }

    public static <P extends GamePlayer<?, ?>> Codec<GamePlayerManagerImpl<P>> createCodec(Codec<P> gamePlayerCodec) {
        return RecordCodecBuilder.create(instance -> instance.group((App)gamePlayerCodec.listOf().fieldOf("in_game").forGetter(manager -> manager.players), (App)Codec.BOOL.fieldOf("tick_hider_time").forGetter(manager -> manager.tickHiderTime), (App)class_4844.field_25122.optionalFieldOf("hider").forGetter(GamePlayerManagerImpl::getHiderUUID)).apply((Applicative)instance, GamePlayerManagerImpl::new));
    }

    private Optional<UUID> getHiderUUID() {
        return Optional.ofNullable(this.hider == null ? null : ((GamePlayer)this.hider).getUuid());
    }

    @Override
    @Nullable
    public P getGamePlayer(UUID uuid) {
        return (P)((GamePlayer)this.uuidToPlayer.get(uuid));
    }

    @Override
    public void addPlayer(P gamePlayer) {
        GamePlayer prevGamePlayer = (GamePlayer)this.uuidToPlayer.put(((GamePlayer)gamePlayer).getUuid(), gamePlayer);
        if (prevGamePlayer != null) {
            this.players.remove(prevGamePlayer);
        }
        this.players.add(gamePlayer);
    }

    @Override
    public void removePlayer(UUID uuid) {
        GamePlayer gamePlayer = (GamePlayer)this.uuidToPlayer.remove(uuid);
        if (gamePlayer != null) {
            this.players.remove(gamePlayer);
        }
        if (this.hider != null && ((GamePlayer)this.hider).getUuid().equals(uuid)) {
            this.setHider(null);
        }
    }

    @Override
    public void disconnectPlayer(UUID uuid) {
        GamePlayer gamePlayer = (GamePlayer)this.uuidToPlayer.get(uuid);
        if (gamePlayer != null) {
            gamePlayer.invalidatePlayer();
        }
        if (this.hider != null && ((GamePlayer)this.hider).getUuid().equals(uuid)) {
            this.tickHiderTime = false;
        }
    }

    @Override
    public void setHider(@Nullable P hider) {
        this.hider = hider;
        if (this.hider == null) {
            this.tickHiderTime = false;
        }
    }

    @Override
    public void setHidingTime(UUID uuid, int hidingTime) {
        GamePlayer gamePlayer = (GamePlayer)this.uuidToPlayer.get(uuid);
        if (gamePlayer != null) {
            gamePlayer.setHidingTime(hidingTime);
        }
    }

    @Override
    public void setHidingTimes(Object2IntMap<UUID> times) {
        times.forEach(this::setHidingTime);
    }

    @Override
    public void clearPlayers() {
        this.uuidToPlayer.clear();
        this.players.clear();
        this.tickHiderTime = false;
        this.hider = null;
    }

    @Override
    public void setHider(@Nullable class_1657 player, boolean tickHiderTime) {
        this.tickHiderTime = tickHiderTime;
        this.setHider(player == null ? null : (GamePlayer)this.uuidToPlayer.get(player.method_5667()));
    }

    @Override
    public void setHider(@Nullable UUID uuid, int currentHiderTime, boolean tickHiderTime) {
        if (uuid != null) {
            this.hider = (GamePlayer)this.uuidToPlayer.get(uuid);
            if (this.hider != null) {
                ((GamePlayer)this.hider).setHidingTime(currentHiderTime);
            }
        }
        this.tickHiderTime = this.hider != null && tickHiderTime;
    }

    @Override
    public List<P> setHidingTimes(Collection<? extends class_1657> players, IntUnaryOperator timeOperator) {
        ArrayList<GamePlayer> list = new ArrayList<GamePlayer>();
        for (class_1657 class_16572 : players) {
            GamePlayer gamePlayer = (GamePlayer)this.uuidToPlayer.get(class_16572.method_5667());
            if (gamePlayer == null) continue;
            gamePlayer.setHidingTime(timeOperator.applyAsInt(gamePlayer.getHidingTime()));
            list.add(gamePlayer);
        }
        return list;
    }

    @Override
    public boolean setHiderTimeTicking(boolean tickHiderTime) {
        if (this.hider != null) {
            this.tickHiderTime = tickHiderTime;
            return true;
        }
        return false;
    }

    @Override
    public int getGamePlayerCount() {
        return this.players.size();
    }

    public void tick() {
        if (this.hider != null && this.tickHiderTime) {
            ((GamePlayer)this.hider).incrementHidingTime();
        }
    }

    public GamePlayerListS2CPayload createPlayerListPayload() {
        return GamePlayerListS2CPayload.create(this.hider, this.tickHiderTime, this.players);
    }

    public HiderStatusS2CPayload createHiderStatusPayload() {
        return HiderStatusS2CPayload.create(this.hider, this.tickHiderTime);
    }
}

