/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.hideandseek.common.game.player;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GamePlayer<P extends class_1657, W extends class_1937>
implements Comparable<GamePlayer<P, W>> {
    protected final UUID uuid;
    @Nullable
    protected P player;
    protected int hidingTime = -1;

    public GamePlayer(UUID uuid) {
        this.uuid = uuid;
    }

    protected abstract List<P> getPlayers(W var1);

    public UUID getUuid() {
        return this.uuid;
    }

    @Nullable
    public P getPlayer() {
        return this.player;
    }

    @Nullable
    public P getPlayer(W world) {
        if (this.player == null) {
            for (class_1657 player : this.getPlayers(world)) {
                if (!player.method_5667().equals(this.uuid)) continue;
                this.player = player;
                break;
            }
        }
        return this.player;
    }

    public void invalidatePlayer() {
        this.player = null;
    }

    public int getHidingTime() {
        return this.hidingTime;
    }

    public void setHidingTime(int hidingTime) {
        this.hidingTime = hidingTime;
    }

    public boolean hasHidden() {
        return this.hidingTime >= 0;
    }

    public int incrementHidingTime() {
        return ++this.hidingTime;
    }

    @Override
    public int compareTo(@NotNull GamePlayer<P, W> player) {
        int i = Integer.compare(this.hidingTime, player.hidingTime) * -1;
        if (i == 0) {
            return this.uuid.compareTo(player.uuid);
        }
        return i;
    }

    public boolean equals(Object o) {
        if (!(o instanceof GamePlayer)) {
            return false;
        }
        GamePlayer that = (GamePlayer)o;
        return Objects.equals(this.uuid, that.uuid);
    }

    public int hashCode() {
        return Objects.hashCode(this.uuid);
    }
}

