/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.hideandseek.common.game.marking;

import com.eightsidedsquare.hideandseek.common.game.marking.WorldMarkingContext;
import com.eightsidedsquare.hideandseek.common.game.marking.WorldMarkingOperation;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;

public class WorldMarkingQueue
implements WorldMarkingContext {
    public static final Codec<WorldMarkingQueue> CODEC = WorldMarkingOperation.CODEC.listOf().xmap(WorldMarkingQueue::new, queue -> queue.operations);
    private final List<WorldMarkingOperation> operations;

    public WorldMarkingQueue(List<WorldMarkingOperation> operations) {
        this.operations = new ObjectArrayList(operations);
    }

    public WorldMarkingQueue() {
        this.operations = new ObjectArrayList();
    }

    public void clear() {
        this.operations.clear();
    }

    public void applyAll(WorldMarkingContext ctx) {
        this.operations.forEach(op -> op.apply(ctx));
        this.operations.clear();
    }

    @Override
    public void mark(int x1, int z1, int x2, int z2, boolean value) {
        this.operations.add(new WorldMarkingOperation.Rectangle(x1, z1, x2, z2, value));
    }

    @Override
    public void mark(int x, int z, int radius, boolean value) {
        this.operations.add(new WorldMarkingOperation.Circle(x, z, radius, value, false));
    }

    @Override
    public void markInverted(int x, int z, int radius, boolean value) {
        this.operations.add(new WorldMarkingOperation.Circle(x, z, radius, value, true));
    }
}

