/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.hideandseek.common.game.marking;

import com.eightsidedsquare.hideandseek.common.game.marking.WorldMarkingContext;
import com.eightsidedsquare.hideandseek.core.ModInit;
import com.eightsidedsquare.hideandseek.core.ModRegistries;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;

public interface WorldMarkingOperation {
    public static final Codec<WorldMarkingOperation> CODEC = ModRegistries.WORLD_MARKING_OPERATION.method_39673().dispatchStable(WorldMarkingOperation::getCodec, Function.identity());

    public static void init() {
        ModInit.REGISTRY.worldMarkingOperation("rectangle", Rectangle.CODEC);
        ModInit.REGISTRY.worldMarkingOperation("circle", Circle.CODEC);
    }

    public MapCodec<? extends WorldMarkingOperation> getCodec();

    public void apply(WorldMarkingContext var1);

    public record Rectangle(int x1, int z1, int x2, int z2, boolean value) implements WorldMarkingOperation
    {
        public static final MapCodec<Rectangle> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("x1").forGetter(Rectangle::x1), (App)Codec.INT.fieldOf("z1").forGetter(Rectangle::x1), (App)Codec.INT.fieldOf("x2").forGetter(Rectangle::x1), (App)Codec.INT.fieldOf("z2").forGetter(Rectangle::x1), (App)Codec.BOOL.fieldOf("value").forGetter(Rectangle::value)).apply((Applicative)instance, Rectangle::new));

        @Override
        public MapCodec<? extends WorldMarkingOperation> getCodec() {
            return CODEC;
        }

        @Override
        public void apply(WorldMarkingContext ctx) {
            ctx.mark(this.x1, this.z1, this.x2, this.z2, this.value);
        }
    }

    public record Circle(int x, int z, int radius, boolean value, boolean invert) implements WorldMarkingOperation
    {
        public static final MapCodec<Circle> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("x").forGetter(Circle::x), (App)Codec.INT.fieldOf("z").forGetter(Circle::z), (App)Codec.INT.fieldOf("radius").forGetter(Circle::radius), (App)Codec.BOOL.fieldOf("value").forGetter(Circle::value), (App)Codec.BOOL.fieldOf("invert").forGetter(Circle::invert)).apply((Applicative)instance, Circle::new));

        @Override
        public MapCodec<? extends WorldMarkingOperation> getCodec() {
            return CODEC;
        }

        @Override
        public void apply(WorldMarkingContext ctx) {
            if (this.invert) {
                ctx.markInverted(this.x, this.z, this.radius, this.value);
            } else {
                ctx.mark(this.x, this.z, this.radius, this.value);
            }
        }
    }
}

