/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.hideandseek.common.game.marking;

import com.eightsidedsquare.hideandseek.common.game.marking.ChunkMarking;
import com.eightsidedsquare.hideandseek.common.game.marking.WorldMarkingContext;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_1923;
import net.minecraft.class_2540;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_5699;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class WorldMarkingData
implements WorldMarkingContext {
    public static final Codec<WorldMarkingData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ChunkMarking.CODEC.listOf().fieldOf("markings").forGetter(WorldMarkingData::getMarkings), (App)class_5699.field_33441.fieldOf("size").forGetter(WorldMarkingData::getSize), (App)class_1923.field_54241.fieldOf("origin").forGetter(WorldMarkingData::getOrigin)).apply((Applicative)instance, WorldMarkingData::new));
    public static final class_9139<class_2540, WorldMarkingData> PACKET_CODEC = class_9139.method_56436((class_9139)ChunkMarking.PACKET_CODEC.method_56433(class_9135.method_56363()), WorldMarkingData::getMarkings, (class_9139)class_9135.field_48550, WorldMarkingData::getSize, (class_9139)class_1923.field_54242, WorldMarkingData::getOrigin, WorldMarkingData::new);
    private final List<ChunkMarking> markings;
    private final int size;
    private final class_1923 origin;
    @Nullable
    private BiConsumer<class_1923, ChunkMarking> markingCallback;

    public WorldMarkingData(int size, class_1923 origin) {
        this.markings = new ObjectArrayList();
        for (int i = 0; i < size * size; ++i) {
            this.markings.add(ChunkMarking.Constant.UNMARKED);
        }
        this.size = size;
        this.origin = origin;
    }

    private WorldMarkingData(List<ChunkMarking> markings, int size, class_1923 origin) {
        if (markings.size() != size * size) {
            throw new IllegalArgumentException("Size of markings list does not match size");
        }
        this.markings = new ObjectArrayList(markings);
        this.size = size;
        this.origin = origin;
    }

    public void setMarkingCallback(@Nullable BiConsumer<class_1923, ChunkMarking> markingCallback) {
        this.markingCallback = markingCallback;
    }

    public List<ChunkMarking> getMarkings() {
        return this.markings;
    }

    public int getSize() {
        return this.size;
    }

    public class_1923 getOrigin() {
        return this.origin;
    }

    @Override
    public void mark(int x1, int z1, int x2, int z2, boolean value) {
        int chunkX1 = class_4076.method_18675((int)x1);
        int chunkZ1 = class_4076.method_18675((int)z1);
        int chunkX2 = class_4076.method_18675((int)x2);
        int chunkZ2 = class_4076.method_18675((int)z2);
        int blockRelativeX1 = this.getBlockRelativeX(x1);
        int blockRelativeZ1 = this.getBlockRelativeZ(z1);
        int blockRelativeX2 = this.getBlockRelativeX(x2);
        int blockRelativeZ2 = this.getBlockRelativeZ(z2);
        for (int chunkX = chunkX1; chunkX <= chunkX2; ++chunkX) {
            for (int chunkZ = chunkZ1; chunkZ <= chunkZ2; ++chunkZ) {
                int chunkRelativeX = this.getChunkRelativeX(chunkX);
                int chunkRelativeZ = this.getChunkRelativeZ(chunkZ);
                int blockRelativeX = class_4076.method_18688((int)chunkRelativeX);
                int blockRelativeZ = class_4076.method_18688((int)chunkRelativeZ);
                ChunkMarking marking = this.getMarking(chunkRelativeX, chunkRelativeZ).mark(blockRelativeX1 - blockRelativeX, blockRelativeZ1 - blockRelativeZ, blockRelativeX2 - blockRelativeX, blockRelativeZ2 - blockRelativeZ, value);
                this.setMarking(chunkRelativeX, chunkRelativeZ, marking);
            }
        }
    }

    @Override
    public void mark(int x, int z, int radius, boolean value) {
        int chunkX1 = class_4076.method_18675((int)(x - radius));
        int chunkZ1 = class_4076.method_18675((int)(z - radius));
        int chunkX2 = class_4076.method_18675((int)(x + radius));
        int chunkZ2 = class_4076.method_18675((int)(z + radius));
        int blockRelativeX = this.getBlockRelativeX(x);
        int blockRelativeZ = this.getBlockRelativeZ(z);
        for (int chunkX = chunkX1; chunkX <= chunkX2; ++chunkX) {
            for (int chunkZ = chunkZ1; chunkZ <= chunkZ2; ++chunkZ) {
                int chunkRelativeX = this.getChunkRelativeX(chunkX);
                int chunkRelativeZ = this.getChunkRelativeZ(chunkZ);
                ChunkMarking marking = this.getMarking(chunkRelativeX, chunkRelativeZ).mark(blockRelativeX - class_4076.method_18688((int)chunkRelativeX), blockRelativeZ - class_4076.method_18688((int)chunkRelativeZ), radius, value);
                this.setMarking(chunkRelativeX, chunkRelativeZ, marking);
            }
        }
    }

    @Override
    public void markInverted(int x, int z, int radius, boolean value) {
        int blockRelativeX = this.getBlockRelativeX(x);
        int blockRelativeZ = this.getBlockRelativeZ(z);
        for (int chunkRelativeX = 0; chunkRelativeX < this.size; ++chunkRelativeX) {
            for (int chunkRelativeZ = 0; chunkRelativeZ < this.size; ++chunkRelativeZ) {
                ChunkMarking marking = this.getMarking(chunkRelativeX, chunkRelativeZ).markInverted(blockRelativeX - class_4076.method_18688((int)chunkRelativeX), blockRelativeZ - class_4076.method_18688((int)chunkRelativeZ), radius, value);
                this.setMarking(chunkRelativeX, chunkRelativeZ, marking);
            }
        }
    }

    public ChunkMarking getMarking(int chunkRelativeX, int chunkRelativeZ) {
        return this.markings.get(chunkRelativeX * this.size + chunkRelativeZ);
    }

    public void setMarking(class_1923 pos, ChunkMarking marking) {
        this.markings.set(this.getChunkRelativeX(pos.field_9181) * this.size + this.getChunkRelativeZ(pos.field_9180), marking);
        if (this.markingCallback != null) {
            this.markingCallback.accept(pos, marking);
        }
    }

    private void setMarking(int chunkRelativeX, int chunkRelativeZ, ChunkMarking marking) {
        this.markings.set(chunkRelativeX * this.size + chunkRelativeZ, marking);
        if (this.markingCallback != null) {
            this.markingCallback.accept(new class_1923(chunkRelativeX + this.origin.field_9181, chunkRelativeZ + this.origin.field_9180), marking);
        }
    }

    public boolean contains(int chunkX, int chunkZ) {
        return chunkX >= this.origin.field_9181 && chunkX < this.origin.field_9181 + this.size && chunkZ >= this.origin.field_9180 && chunkZ < this.origin.field_9180 + this.size;
    }

    public boolean isMarked(int x, int z) {
        int chunkX = class_4076.method_18675((int)x);
        int chunkZ = class_4076.method_18675((int)z);
        int chunkRelativeX = this.getChunkRelativeX(chunkX);
        int chunkRelativeZ = this.getChunkRelativeZ(chunkZ);
        return this.contains(chunkX, chunkZ) && this.getMarking(chunkRelativeX, chunkRelativeZ).isMarked(this.getBlockRelativeX(x) - class_4076.method_18688((int)chunkRelativeX), this.getBlockRelativeZ(z) - class_4076.method_18688((int)chunkRelativeZ));
    }

    public int getChunkRelativeX(int x) {
        return class_3532.method_15340((int)(x - this.origin.field_9181), (int)0, (int)(this.size - 1));
    }

    public int getChunkRelativeZ(int z) {
        return class_3532.method_15340((int)(z - this.origin.field_9180), (int)0, (int)(this.size - 1));
    }

    public int getBlockRelativeX(int x) {
        return x - this.origin.method_8326();
    }

    public int getBlockRelativeZ(int z) {
        return z - this.origin.method_8328();
    }
}

