/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.hideandseek.common.game.marking;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.BitSet;
import java.util.function.Function;
import net.minecraft.class_2540;
import net.minecraft.class_3532;
import net.minecraft.class_5699;
import net.minecraft.class_5742;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public sealed interface ChunkMarking {
    public static final Codec<Constant> CONSTANT_CODEC = Codec.BOOL.xmap(ChunkMarking::constant, Constant::getValue);
    public static final class_9139<ByteBuf, Constant> CONSTANT_PACKET_CODEC = class_9135.field_48547.method_56432(ChunkMarking::constant, Constant::getValue);
    public static final Codec<Defined> DEFINED_CODEC = class_5699.field_40724.xmap(Defined::new, Defined::values);
    public static final class_9139<class_2540, Defined> DEFINED_PACKET_CODEC = class_9139.method_56437((buf, defined) -> buf.method_46252(defined.values, 256), buf -> new Defined(buf.method_46254(256)));
    public static final Codec<ChunkMarking> CODEC = Codec.either(CONSTANT_CODEC, DEFINED_CODEC).xmap(ChunkMarking::map, ChunkMarking::toEither);
    public static final class_9139<class_2540, ChunkMarking> PACKET_CODEC = class_9135.method_57995(CONSTANT_PACKET_CODEC, DEFINED_PACKET_CODEC).method_56432(ChunkMarking::map, ChunkMarking::toEither);

    private static ChunkMarking map(Either<Constant, Defined> either) {
        return (ChunkMarking)either.map(Function.identity(), Function.identity());
    }

    public static Constant constant(boolean value) {
        return value ? Constant.MARKED : Constant.UNMARKED;
    }

    public boolean isMarked(int var1, int var2);

    public boolean isBiomeSectionFullyMarked(int var1, int var2);

    public ChunkMarking mark(int var1, int var2, boolean var3);

    public ChunkMarking mark(int var1, int var2, int var3, int var4, boolean var5);

    public ChunkMarking mark(int var1, int var2, int var3, boolean var4);

    public ChunkMarking markInverted(int var1, int var2, int var3, boolean var4);

    public Either<Constant, Defined> toEither();

    public static final class Constant
    implements ChunkMarking {
        public static final Constant MARKED = new Constant(true);
        public static final Constant UNMARKED = new Constant(false);
        private final boolean value;

        private Constant(boolean value) {
            this.value = value;
        }

        public boolean getValue() {
            return this.value;
        }

        @Override
        public boolean isMarked(int x, int z) {
            return this.value;
        }

        @Override
        public boolean isBiomeSectionFullyMarked(int biomeX, int biomeZ) {
            return this.value;
        }

        @Override
        public ChunkMarking mark(int x, int z, boolean value) {
            if (value == this.value) {
                return this;
            }
            Defined defined = new Defined(this.value);
            return defined.mark(x, z, value);
        }

        @Override
        public ChunkMarking mark(int x1, int z1, int x2, int z2, boolean value) {
            if (value == this.value) {
                return this;
            }
            Defined defined = new Defined(this.value);
            return defined.mark(x1, z1, x2, z2, value);
        }

        @Override
        public ChunkMarking mark(int x, int z, int distance, boolean value) {
            if (value == this.value) {
                return this;
            }
            Defined defined = new Defined(this.value);
            return defined.mark(x, z, distance, value);
        }

        @Override
        public ChunkMarking markInverted(int x, int z, int distance, boolean value) {
            if (value == this.value) {
                return this;
            }
            Defined defined = new Defined(this.value);
            return defined.markInverted(x, z, distance, value);
        }

        @Override
        public Either<Constant, Defined> toEither() {
            return Either.left((Object)this);
        }
    }

    public record Defined(BitSet values) implements ChunkMarking
    {
        public Defined {
            if (values.length() > 256) {
                throw new IllegalArgumentException("Defined chunk marking values has unexpected size (" + values.length() + "/256)");
            }
        }

        public Defined(boolean value) {
            this(new BitSet(256));
            if (value) {
                this.values.set(0, 256, true);
            }
        }

        private static int clamp(int v) {
            return class_3532.method_15340((int)v, (int)0, (int)15);
        }

        private ChunkMarking simplify(boolean value) {
            if (!value && this.values.isEmpty()) {
                return Constant.UNMARKED;
            }
            if (value && this.values.cardinality() >= 256) {
                return Constant.MARKED;
            }
            return this;
        }

        @Override
        public boolean isMarked(int x, int z) {
            return this.values.get(x * 16 + z);
        }

        @Override
        public boolean isBiomeSectionFullyMarked(int biomeX, int biomeZ) {
            int maxX = class_5742.method_33101((int)(biomeX + 1)) - 1;
            int maxZ = class_5742.method_33101((int)(biomeZ + 1)) - 1;
            for (int x = class_5742.method_33101((int)biomeX); x <= maxX; ++x) {
                for (int z = class_5742.method_33101((int)biomeZ); z <= maxZ; ++z) {
                    if (this.isMarked(x, z)) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public ChunkMarking mark(int x, int z, boolean value) {
            this.values.set(x * 16 + z, value);
            return this.simplify(value);
        }

        @Override
        public ChunkMarking mark(int x1, int z1, int x2, int z2, boolean value) {
            x1 = Defined.clamp(x1);
            z1 = Defined.clamp(z1);
            x2 = Defined.clamp(x2);
            z2 = Defined.clamp(z2);
            for (int x = x1; x <= x2; ++x) {
                for (int z = z1; z <= z2; ++z) {
                    this.values.set(x * 16 + z, value);
                }
            }
            return this.simplify(value);
        }

        @Override
        public ChunkMarking mark(int centerX, int centerZ, int distance, boolean value) {
            int sqDist = distance * distance;
            if (Defined.edgesInDistance(centerX, centerZ, sqDist)) {
                return ChunkMarking.constant(value);
            }
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    if (!Defined.isInDistance(x, z, centerX, centerZ, sqDist)) continue;
                    this.values.set(x * 16 + z, value);
                }
            }
            return this.simplify(value);
        }

        @Override
        public ChunkMarking markInverted(int centerX, int centerZ, int distance, boolean value) {
            int sqDist = distance * distance;
            if (Defined.edgesInDistance(centerX, centerZ, sqDist)) {
                return this;
            }
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    if (Defined.isInDistance(x, z, centerX, centerZ, sqDist)) continue;
                    this.values.set(x * 16 + z, value);
                }
            }
            return this.simplify(value);
        }

        private static boolean edgesInDistance(int centerX, int centerZ, int sqDist) {
            return Defined.isInDistance(0, 0, centerX, centerZ, sqDist) && Defined.isInDistance(0, 15, centerX, centerZ, sqDist) && Defined.isInDistance(15, 0, centerX, centerZ, sqDist) && Defined.isInDistance(15, 15, centerX, centerZ, sqDist);
        }

        private static boolean isInDistance(int x, int z, int centerX, int centerZ, int sqDist) {
            int a = x - centerX;
            int b = z - centerZ;
            return a * a + b * b <= sqDist;
        }

        @Override
        public Either<Constant, Defined> toEither() {
            return Either.right((Object)this);
        }
    }
}

