/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.hideandseek.common.event;

import com.eightsidedsquare.hideandseek.common.cca.GameComponent;
import com.eightsidedsquare.hideandseek.common.cca.WorldMarkingComponent;
import com.eightsidedsquare.hideandseek.common.game.powerup.PowerupReward;
import com.eightsidedsquare.hideandseek.common.game.question.ActiveQuestion;
import com.eightsidedsquare.hideandseek.common.game.question.Question;
import com.eightsidedsquare.hideandseek.common.network.AnnouncementS2CPayload;
import com.eightsidedsquare.hideandseek.core.ModCriteria;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3966;
import net.minecraft.class_8103;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class GameEventManager
implements ServerPlayConnectionEvents.Join,
ServerLivingEntityEvents.AllowDamage,
ServerLivingEntityEvents.AllowDeath,
PlayerBlockBreakEvents.Before,
AttackBlockCallback,
UseEntityCallback {
    public static final GameEventManager INSTANCE = new GameEventManager();

    public void registerEvents() {
        ServerPlayConnectionEvents.JOIN.register((Object)this);
        ServerLivingEntityEvents.ALLOW_DAMAGE.register((Object)this);
        ServerLivingEntityEvents.ALLOW_DEATH.register((Object)this);
        PlayerBlockBreakEvents.BEFORE.register((Object)this);
        AttackBlockCallback.EVENT.register((Object)this);
        UseEntityCallback.EVENT.register((Object)this);
    }

    public void onPlayReady(class_3244 handler, PacketSender sender, MinecraftServer server) {
        WorldMarkingComponent worldMarkingComponent;
        class_3222 player = handler.field_14140;
        GameComponent gameComponent = GameComponent.get((class_1937)player.method_51469());
        if (gameComponent != null) {
            gameComponent.onPlayerJoin(player);
        }
        if ((worldMarkingComponent = WorldMarkingComponent.get((class_1937)player.method_51469())) != null) {
            worldMarkingComponent.onPlayerJoin(player);
        }
    }

    public boolean allowDamage(class_1309 entity, class_1282 source, float amount) {
        if (source.method_5530() || source.method_48789(class_8103.field_42242)) {
            return true;
        }
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            GameComponent component = GameComponent.get((class_1937)player.method_51469());
            if (component == null) {
                return true;
            }
            if (component.isHider((class_1657)player)) {
                return component.isQueueingPhase();
            }
            if (component.isSeeker((class_1657)player)) {
                return component.isQueueingPhase() || component.isSeekingPhase();
            }
        }
        return true;
    }

    public boolean allowDeath(class_1309 entity, class_1282 source, float damageAmount) {
        if (source.method_5530() || source.method_48789(class_8103.field_42242)) {
            return true;
        }
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            GameComponent component = GameComponent.get((class_1937)player.method_51469());
            if (component == null) {
                return true;
            }
            if (component.isHider((class_1657)player)) {
                player.method_6033(player.method_6063());
                return component.isQueueingPhase();
            }
            if (component.isSeeker((class_1657)player)) {
                player.method_6033(player.method_6063());
                player.method_7344().method_7585(20, 2.0f);
                class_3222 hiderPlayer = component.getHider(player.method_51469());
                if (hiderPlayer != null) {
                    component.rewardHider(hiderPlayer, 1, 1, PowerupReward.Cause.DEATH);
                    ServerPlayNetworking.send((class_3222)player, (class_8710)new AnnouncementS2CPayload((class_2561)class_2561.method_43471((String)"hideandseek.seeker_death"), 0.0f, 1.0f));
                }
                return component.isQueueingPhase();
            }
        }
        return true;
    }

    public boolean beforeBlockBreak(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity) {
        if (!world.field_9236) {
            ModCriteria.BLOCK_BROKEN.method_23889((class_3222)player, pos, player.method_6047());
        }
        return true;
    }

    public class_1269 interact(class_1657 player, class_1937 world, class_1268 hand, class_2338 pos, class_2350 direction) {
        if (player.hideandseek$isHiderInSeekingPhase()) {
            ActiveQuestion activeQuestion = player.hideandseek$getActiveQuestion();
            if (activeQuestion != null && activeQuestion.isWaitingNow() && activeQuestion.getQuestion().getResponseTrigger() == Question.ResponseTrigger.BREAK_BLOCK && !pos.equals((Object)player.method_23312())) {
                return class_1269.field_5811;
            }
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    public class_1269 interact(class_1657 player, class_1937 world, class_1268 hand, class_1297 entity, @Nullable class_3966 hitResult) {
        class_3222 hiderPlayer;
        if (world.field_9236) {
            return class_1269.field_5811;
        }
        GameComponent component = GameComponent.get(world);
        if (component != null && component.isSeekingPhase() && component.isSeeker(player) && entity instanceof class_3222 && component.isHider((class_1657)(hiderPlayer = (class_3222)entity))) {
            component.catchHider(hiderPlayer);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }
}

