/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.hideandseek.common.command;

import com.eightsidedsquare.hideandseek.common.cca.GameComponent;
import com.eightsidedsquare.hideandseek.common.cca.WorldMarkingComponent;
import com.eightsidedsquare.hideandseek.common.game.challenge.Challenge;
import com.eightsidedsquare.hideandseek.common.game.marking.WorldMarkingData;
import com.eightsidedsquare.hideandseek.common.game.player.GamePlayerManagerImpl;
import com.eightsidedsquare.hideandseek.common.game.player.ServerGamePlayer;
import com.eightsidedsquare.hideandseek.common.game.powerup.Powerup;
import com.eightsidedsquare.hideandseek.common.game.question.Question;
import com.eightsidedsquare.hideandseek.common.network.ActiveQuestionS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.AnnouncementS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.CluesS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.EndResultsS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.QuestionStatesS2CPayload;
import com.eightsidedsquare.hideandseek.core.ModRegistries;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.IntUnaryOperator;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2178;
import net.minecraft.class_2186;
import net.minecraft.class_2245;
import net.minecraft.class_2264;
import net.minecraft.class_2265;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import org.jetbrains.annotations.Nullable;

public class HideAndSeekCommand {
    public static final SimpleCommandExceptionType COMPONENT_NOT_FOUND_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"command.hideandseek.component_not_found"));

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"hideandseek").then(class_2170.method_9247((String)"join").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).executes(ctx -> HideAndSeekCommand.executeJoin(HideAndSeekCommand.getGameComponentOrThrow((CommandContext<class_2168>)ctx), class_2186.method_9312((CommandContext)ctx, (String)"targets")))))).then(class_2170.method_9247((String)"leave").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).executes(ctx -> HideAndSeekCommand.executeLeave(HideAndSeekCommand.getGameComponentOrThrow((CommandContext<class_2168>)ctx), class_2186.method_9312((CommandContext)ctx, (String)"targets")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"hider").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"announce").executes(ctx -> HideAndSeekCommand.executeAnnounceHider(HideAndSeekCommand.getGameComponentOrThrow((CommandContext<class_2168>)ctx)))).then(class_2170.method_9247((String)"results").executes(ctx -> HideAndSeekCommand.executeEndResults(HideAndSeekCommand.getGameComponentOrThrow((CommandContext<class_2168>)ctx)))))).then(class_2170.method_9247((String)"catch").executes(ctx -> HideAndSeekCommand.executeCatchHider((class_2168)ctx.getSource(), HideAndSeekCommand.getGameComponentOrThrow((CommandContext<class_2168>)ctx))))).then(class_2170.method_9247((String)"reset").executes(ctx -> HideAndSeekCommand.executeUpdateHider(HideAndSeekCommand.getGameComponentOrThrow((CommandContext<class_2168>)ctx), null, false)))).then(class_2170.method_9247((String)"pause_timer").executes(ctx -> HideAndSeekCommand.executeUpdateHiderTicking(HideAndSeekCommand.getGameComponentOrThrow((CommandContext<class_2168>)ctx), false)))).then(class_2170.method_9247((String)"unpause_timer").executes(ctx -> HideAndSeekCommand.executeUpdateHiderTicking(HideAndSeekCommand.getGameComponentOrThrow((CommandContext<class_2168>)ctx), true)))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(ctx -> HideAndSeekCommand.executeUpdateHider(HideAndSeekCommand.getGameComponentOrThrow((CommandContext<class_2168>)ctx), class_2186.method_9315((CommandContext)ctx, (String)"target"), true))))).then(class_2170.method_9247((String)"submit_hiding_spot").executes(ctx -> HideAndSeekCommand.executeSubmitHidingSpot((class_2168)ctx.getSource(), HideAndSeekCommand.getGameComponentOrThrow((CommandContext<class_2168>)ctx))))).then(class_2170.method_9247((String)"play").then(class_2170.method_9244((String)"powerup", (ArgumentType)class_7733.method_45603((class_7157)registryAccess, ModRegistries.POWERUP_KEY)).executes(ctx -> HideAndSeekCommand.executePlayPowerup((class_2168)ctx.getSource(), HideAndSeekCommand.getGameComponentOrThrow((CommandContext<class_2168>)ctx), (Powerup)class_7733.method_45602((CommandContext)ctx, (String)"powerup", ModRegistries.POWERUP_KEY).comp_349())))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"hiding_time").then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"time", (ArgumentType)class_2245.method_9489()).executes(ctx -> HideAndSeekCommand.executeSetHidingTimes(HideAndSeekCommand.getGameComponentOrThrow((CommandContext<class_2168>)ctx), class_2186.method_9312((CommandContext)ctx, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"time"))))))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"time", (ArgumentType)class_2245.method_9489()).executes(ctx -> HideAndSeekCommand.executeAddHidingTimes(HideAndSeekCommand.getGameComponentOrThrow((CommandContext<class_2168>)ctx), class_2186.method_9312((CommandContext)ctx, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"time"))))))).then(class_2170.method_9247((String)"reset").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).executes(ctx -> HideAndSeekCommand.executeSetHidingTimes(HideAndSeekCommand.getGameComponentOrThrow((CommandContext<class_2168>)ctx), class_2186.method_9312((CommandContext)ctx, (String)"targets"), 0)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mark").then(class_2170.method_9247((String)"all").executes(ctx -> HideAndSeekCommand.executeMarkAll(HideAndSeekCommand.getWorldMarkingComponentOrThrow((CommandContext<class_2168>)ctx), true)))).then(class_2170.method_9247((String)"box").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"from", (ArgumentType)class_2264.method_9701()).executes(ctx -> HideAndSeekCommand.executeMark(HideAndSeekCommand.getWorldMarkingComponentOrThrow((CommandContext<class_2168>)ctx), class_2264.method_9702((CommandContext)ctx, (String)"from"), class_2264.method_9702((CommandContext)ctx, (String)"from"), true))).then(class_2170.method_9244((String)"to", (ArgumentType)class_2264.method_9701()).executes(ctx -> HideAndSeekCommand.executeMark(HideAndSeekCommand.getWorldMarkingComponentOrThrow((CommandContext<class_2168>)ctx), class_2264.method_9702((CommandContext)ctx, (String)"from"), class_2264.method_9702((CommandContext)ctx, (String)"to"), true)))))).then(class_2170.method_9247((String)"circle").then(class_2170.method_9244((String)"center", (ArgumentType)class_2264.method_9701()).then(class_2170.method_9244((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)512)).executes(ctx -> HideAndSeekCommand.executeMark(HideAndSeekCommand.getWorldMarkingComponentOrThrow((CommandContext<class_2168>)ctx), class_2264.method_9702((CommandContext)ctx, (String)"center"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), true)))))).then(class_2170.method_9247((String)"inverted_circle").then(class_2170.method_9244((String)"center", (ArgumentType)class_2264.method_9701()).then(class_2170.method_9244((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)512)).executes(ctx -> HideAndSeekCommand.executeMarkInverted(HideAndSeekCommand.getWorldMarkingComponentOrThrow((CommandContext<class_2168>)ctx), class_2264.method_9702((CommandContext)ctx, (String)"center"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), true))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"unmark").then(class_2170.method_9247((String)"all").executes(ctx -> HideAndSeekCommand.executeMarkAll(HideAndSeekCommand.getWorldMarkingComponentOrThrow((CommandContext<class_2168>)ctx), false)))).then(class_2170.method_9247((String)"box").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"from", (ArgumentType)class_2264.method_9701()).executes(ctx -> HideAndSeekCommand.executeMark(HideAndSeekCommand.getWorldMarkingComponentOrThrow((CommandContext<class_2168>)ctx), class_2264.method_9702((CommandContext)ctx, (String)"from"), class_2264.method_9702((CommandContext)ctx, (String)"from"), false))).then(class_2170.method_9244((String)"to", (ArgumentType)class_2264.method_9701()).executes(ctx -> HideAndSeekCommand.executeMark(HideAndSeekCommand.getWorldMarkingComponentOrThrow((CommandContext<class_2168>)ctx), class_2264.method_9702((CommandContext)ctx, (String)"from"), class_2264.method_9702((CommandContext)ctx, (String)"to"), false)))))).then(class_2170.method_9247((String)"circle").then(class_2170.method_9244((String)"center", (ArgumentType)class_2264.method_9701()).then(class_2170.method_9244((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)512)).executes(ctx -> HideAndSeekCommand.executeMark(HideAndSeekCommand.getWorldMarkingComponentOrThrow((CommandContext<class_2168>)ctx), class_2264.method_9702((CommandContext)ctx, (String)"center"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), false)))))).then(class_2170.method_9247((String)"inverted_circle").then(class_2170.method_9244((String)"center", (ArgumentType)class_2264.method_9701()).then(class_2170.method_9244((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)512)).executes(ctx -> HideAndSeekCommand.executeMarkInverted(HideAndSeekCommand.getWorldMarkingComponentOrThrow((CommandContext<class_2168>)ctx), class_2264.method_9702((CommandContext)ctx, (String)"center"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), false))))))).then(class_2170.method_9247((String)"mark_origin").then(class_2170.method_9244((String)"pos", (ArgumentType)class_2264.method_9701()).then(class_2170.method_9244((String)"size", (ArgumentType)IntegerArgumentType.integer((int)1, (int)512)).executes(ctx -> HideAndSeekCommand.executeMarkOrigin(HideAndSeekCommand.getWorldMarkingComponentOrThrow((CommandContext<class_2168>)ctx), class_2264.method_9702((CommandContext)ctx, (String)"pos"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"size"))))))).then(class_2170.method_9247((String)"clear_markings").executes(ctx -> HideAndSeekCommand.executeClearMarkings(HideAndSeekCommand.getWorldMarkingComponentOrThrow((CommandContext<class_2168>)ctx))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"challenge").then(HideAndSeekCommand.challengeStatus("add", registryAccess, GameComponent::addChallenge))).then(HideAndSeekCommand.challengeStatus("start", registryAccess, GameComponent::startChallenge))).then(HideAndSeekCommand.challengeStatus("remove", registryAccess, GameComponent::removeChallenge))).then(HideAndSeekCommand.challengeStatus("complete", registryAccess, GameComponent::completeChallenge)))).then(class_2170.method_9247((String)"reset").executes(ctx -> HideAndSeekCommand.executeReset(HideAndSeekCommand.getGameComponentOrThrow((CommandContext<class_2168>)ctx))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clue").then(class_2170.method_9247((String)"clear").executes(ctx -> HideAndSeekCommand.executeClearClues(HideAndSeekCommand.getGameComponentOrThrow((CommandContext<class_2168>)ctx))))).then(class_2170.method_9247((String)"send").then(class_2170.method_9244((String)"clue", (ArgumentType)class_2178.method_9281((class_7157)registryAccess)).executes(ctx -> HideAndSeekCommand.executeSendClue(HideAndSeekCommand.getGameComponentOrThrow((CommandContext<class_2168>)ctx), class_2178.method_67414((CommandContext)ctx, (String)"clue"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"question").then(class_2170.method_9247((String)"ask").then(class_2170.method_9244((String)"source", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"question", (ArgumentType)class_7733.method_45603((class_7157)registryAccess, ModRegistries.QUESTION_KEY)).executes(ctx -> HideAndSeekCommand.executeAsk(HideAndSeekCommand.getGameComponentOrThrow((CommandContext<class_2168>)ctx), class_2186.method_9315((CommandContext)ctx, (String)"source"), (Question)class_7733.method_45602((CommandContext)ctx, (String)"question", ModRegistries.QUESTION_KEY).comp_349())))))).then(class_2170.method_9247((String)"clear").executes(ctx -> HideAndSeekCommand.executeClearQuestions(HideAndSeekCommand.getGameComponentOrThrow((CommandContext<class_2168>)ctx)))))).then(class_2170.method_9247((String)"announce").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"text", (ArgumentType)class_2178.method_9281((class_7157)registryAccess)).executes(ctx -> HideAndSeekCommand.executeAnnouncement(HideAndSeekCommand.getGameComponentOrThrow((CommandContext<class_2168>)ctx), class_2178.method_67414((CommandContext)ctx, (String)"text"), 0.0f, 1.0f))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"y", (ArgumentType)FloatArgumentType.floatArg()).executes(ctx -> HideAndSeekCommand.executeAnnouncement(HideAndSeekCommand.getGameComponentOrThrow((CommandContext<class_2168>)ctx), class_2178.method_67414((CommandContext)ctx, (String)"text"), FloatArgumentType.getFloat((CommandContext)ctx, (String)"y"), 1.0f))).then(class_2170.method_9244((String)"size", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(ctx -> HideAndSeekCommand.executeAnnouncement(HideAndSeekCommand.getGameComponentOrThrow((CommandContext<class_2168>)ctx), class_2178.method_67414((CommandContext)ctx, (String)"text"), FloatArgumentType.getFloat((CommandContext)ctx, (String)"y"), FloatArgumentType.getFloat((CommandContext)ctx, (String)"size")))))))).then(class_2170.method_9247((String)"size").then(class_2170.method_9244((String)"size", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(ctx -> HideAndSeekCommand.executeSetSize(HideAndSeekCommand.getGameComponentOrThrow((CommandContext<class_2168>)ctx), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"size"))))));
    }

    private static LiteralArgumentBuilder<class_2168> challengeStatus(String name, class_7157 registryAccess, BiConsumer<GameComponent, class_6880<Challenge>> consumer) {
        return (LiteralArgumentBuilder)class_2170.method_9247((String)name).then(class_2170.method_9244((String)"challenge", (ArgumentType)class_7733.method_45603((class_7157)registryAccess, ModRegistries.CHALLENGE_KEY)).executes(ctx -> HideAndSeekCommand.executeChallengeStatus(HideAndSeekCommand.getGameComponentOrThrow((CommandContext<class_2168>)ctx), (class_6880.class_6883<Challenge>)class_7733.method_45602((CommandContext)ctx, (String)"challenge", ModRegistries.CHALLENGE_KEY), consumer)));
    }

    private static GameComponent getGameComponentOrThrow(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        GameComponent component = GameComponent.get((class_1937)((class_2168)ctx.getSource()).method_9225());
        if (component != null) {
            return component;
        }
        throw COMPONENT_NOT_FOUND_EXCEPTION.create();
    }

    private static WorldMarkingComponent getWorldMarkingComponentOrThrow(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        WorldMarkingComponent component = WorldMarkingComponent.get((class_1937)((class_2168)ctx.getSource()).method_9225());
        if (component != null) {
            return component;
        }
        throw COMPONENT_NOT_FOUND_EXCEPTION.create();
    }

    private static int executeJoin(GameComponent component, Collection<class_3222> targets) {
        component.addPlayers(targets);
        return targets.size();
    }

    private static int executeLeave(GameComponent component, Collection<class_3222> targets) {
        component.removePlayers(targets);
        return targets.size();
    }

    private static int executeUpdateHider(GameComponent component, @Nullable class_3222 player, boolean tickHiderTime) {
        component.setHider((class_1657)player, tickHiderTime);
        return 1;
    }

    private static int executeUpdateHiderTicking(GameComponent component, boolean tickHiderTime) {
        component.setHiderTimeTicking(tickHiderTime);
        return 1;
    }

    private static int executeUpdateHidingTimes(GameComponent component, Collection<class_3222> targets, IntUnaryOperator timeOperator) {
        component.setHidingTimes(targets, timeOperator);
        return 1;
    }

    private static int executeSetHidingTimes(GameComponent component, Collection<class_3222> targets, int time) {
        return HideAndSeekCommand.executeUpdateHidingTimes(component, targets, currentTime -> time);
    }

    private static int executeAddHidingTimes(GameComponent component, Collection<class_3222> targets, int time) {
        return HideAndSeekCommand.executeUpdateHidingTimes(component, targets, currentTime -> currentTime + time);
    }

    private static int executeMark(WorldMarkingComponent component, class_2265 from, class_2265 to, boolean value) {
        component.mark(from, to, value);
        return 1;
    }

    private static int executeMark(WorldMarkingComponent component, class_2265 center, int radius, boolean value) {
        component.mark(center, radius, value);
        return 1;
    }

    private static int executeMarkInverted(WorldMarkingComponent component, class_2265 center, int radius, boolean value) {
        component.markInverted(center, radius, value);
        return 1;
    }

    private static int executeMarkAll(WorldMarkingComponent component, boolean value) {
        component.markAll(value);
        return 1;
    }

    private static int executeMarkOrigin(WorldMarkingComponent component, class_2265 pos, int size) {
        component.setData(new WorldMarkingData(size, pos.method_34873()));
        return 1;
    }

    private static int executeClearMarkings(WorldMarkingComponent component) {
        component.setData(null);
        return 1;
    }

    private static int executeChallengeStatus(GameComponent component, class_6880.class_6883<Challenge> challenge, BiConsumer<GameComponent, class_6880<Challenge>> consumer) {
        consumer.accept(component, (class_6880<Challenge>)challenge);
        return 1;
    }

    private static int executeAnnounceHider(GameComponent component) {
        component.announceHider(0);
        return 1;
    }

    private static int executeEndResults(GameComponent component) {
        EndResultsS2CPayload endResultsPayload = EndResultsS2CPayload.create(0, component);
        if (endResultsPayload != null) {
            component.sendToAll(endResultsPayload);
        }
        return 1;
    }

    private static int executeReset(GameComponent component) {
        component.reset();
        return 1;
    }

    private static int executeSubmitHidingSpot(class_2168 source, GameComponent component) {
        ServerGamePlayer hiderGamePlayer = (ServerGamePlayer)((GamePlayerManagerImpl)component.getPlayerManager()).hider;
        if (hiderGamePlayer == null) {
            return 0;
        }
        class_3222 hiderPlayer = (class_3222)hiderGamePlayer.getPlayer(source.method_9225());
        if (hiderPlayer == null) {
            return 0;
        }
        component.tryAcceptingHidingSpot(hiderPlayer);
        return 1;
    }

    private static int executeClearClues(GameComponent component) {
        component.getClues().clear();
        component.sendToSeekers(CluesS2CPayload.CLEAR);
        return 1;
    }

    private static int executeSendClue(GameComponent component, class_2561 clue) {
        component.getClues().addClue(clue);
        component.sendToSeekers(new CluesS2CPayload(clue));
        return 1;
    }

    private static int executeAsk(GameComponent component, class_3222 source, Question question) {
        component.askQuestion(source, question);
        return 1;
    }

    private static int executeClearQuestions(GameComponent component) {
        component.sendToAll(QuestionStatesS2CPayload.CLEAR);
        component.sendToAll(ActiveQuestionS2CPayload.of(null));
        component.getQuestionStates().clear();
        component.setActiveQuestion(null);
        component.setIncomingClue(null);
        return 1;
    }

    private static int executePlayPowerup(class_2168 source, GameComponent component, Powerup powerup) {
        class_3222 hider = component.getHider(source.method_9225());
        if (hider != null) {
            component.playPowerup(hider, powerup);
        }
        return 1;
    }

    private static int executeAnnouncement(GameComponent component, class_2561 text, float y, float size) {
        component.sendToAll(new AnnouncementS2CPayload(text, y, size));
        return 1;
    }

    private static int executeCatchHider(class_2168 source, GameComponent component) {
        class_3222 hider = component.getHider(source.method_9225());
        if (hider != null) {
            component.catchHider(hider);
        }
        return 1;
    }

    private static int executeSetSize(GameComponent component, int size) {
        component.setDefaultSize(size);
        return 1;
    }
}

