/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.hideandseek.common.cca;

import com.eightsidedsquare.hideandseek.common.cca.GameComponent;
import com.eightsidedsquare.hideandseek.common.game.marking.ChunkMarking;
import com.eightsidedsquare.hideandseek.common.game.marking.WorldMarkingContext;
import com.eightsidedsquare.hideandseek.common.game.marking.WorldMarkingData;
import com.eightsidedsquare.hideandseek.common.game.marking.WorldMarkingQueue;
import com.eightsidedsquare.hideandseek.common.network.ClearWorldMarkingsS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.WorldMarkingChangesS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.WorldMarkingsS2CPayload;
import com.eightsidedsquare.hideandseek.core.ModComponents;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2265;
import net.minecraft.class_3222;
import net.minecraft.class_4076;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.cca.api.v3.component.Component;
import org.ladysnake.cca.api.v3.component.tick.ServerTickingComponent;

public class WorldMarkingComponent
implements Component,
ServerTickingComponent,
WorldMarkingContext {
    private final class_1937 world;
    private final Map<class_1923, ChunkMarking> changes = new Object2ObjectOpenHashMap();
    @Nullable
    private WorldMarkingData data;
    private WorldMarkingQueue queue = new WorldMarkingQueue();

    public WorldMarkingComponent(class_1937 world) {
        this.world = world;
    }

    @Nullable
    public static WorldMarkingComponent get(class_1937 world) {
        if (world.method_27983().equals(class_1937.field_25179)) {
            return (WorldMarkingComponent)ModComponents.WORLD_MARKING.get((Object)world);
        }
        return null;
    }

    public void serverTick() {
        if (!this.changes.isEmpty()) {
            this.sendChanges();
            this.changes.clear();
        }
    }

    @Nullable
    public WorldMarkingData getData() {
        return this.data;
    }

    public WorldMarkingQueue getQueue() {
        return this.queue;
    }

    public void setData(@Nullable WorldMarkingData data) {
        GameComponent component;
        this.data = data;
        this.queue.clear();
        if (this.data != null) {
            this.data.setMarkingCallback(this.changes::put);
        }
        if ((component = GameComponent.get(this.world)) == null) {
            return;
        }
        if (this.data == null) {
            component.sendToAll(ClearWorldMarkingsS2CPayload.INSTANCE);
        } else {
            component.sendToAll(WorldMarkingsS2CPayload.of(this.data));
        }
    }

    @Override
    public void mark(int x1, int z1, int x2, int z2, boolean value) {
        if (this.data != null) {
            this.data.mark(x1, z1, x2, z2, value);
        }
    }

    public void mark(class_2265 from, class_2265 to, boolean value) {
        this.mark(from.comp_638(), from.comp_639(), to.comp_638(), to.comp_639(), value);
    }

    @Override
    public void mark(int x, int z, int radius, boolean value) {
        if (this.data != null) {
            this.data.mark(x, z, radius, value);
        }
    }

    public void mark(class_2265 center, int radius, boolean value) {
        this.mark(center.comp_638(), center.comp_639(), radius, value);
    }

    @Override
    public void markInverted(int x, int z, int radius, boolean value) {
        if (this.data != null) {
            this.data.markInverted(x, z, radius, value);
        }
    }

    public void markInverted(class_2265 center, int radius, boolean value) {
        this.markInverted(center.comp_638(), center.comp_639(), radius, value);
    }

    public void markAll(boolean value) {
        if (this.data != null) {
            class_1923 origin = this.data.getOrigin();
            int x1 = origin.method_8326();
            int z1 = origin.method_8328();
            int x2 = origin.method_8327() + class_4076.method_18688((int)(this.data.getSize() - 1));
            int z2 = origin.method_8329() + class_4076.method_18688((int)(this.data.getSize() - 1));
            this.data.mark(x1, z1, x2, z2, value);
        }
    }

    private void sendChanges() {
        GameComponent component = GameComponent.get(this.world);
        if (component != null) {
            WorldMarkingChangesS2CPayload payload = WorldMarkingChangesS2CPayload.create(new HashMap<class_1923, ChunkMarking>(this.changes));
            component.sendToAll(payload);
        }
    }

    public void onPlayerJoin(class_3222 player) {
        if (this.data != null) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)WorldMarkingsS2CPayload.of(this.data));
        }
    }

    public void readData(class_11368 view) {
        this.data = view.method_71426("data", WorldMarkingData.CODEC).orElse(null);
        if (this.data != null) {
            this.data.setMarkingCallback(this.changes::put);
        }
        this.queue = view.method_71426("queue", WorldMarkingQueue.CODEC).orElseGet(WorldMarkingQueue::new);
    }

    public void writeData(class_11372 view) {
        view.method_71477("data", WorldMarkingData.CODEC, (Object)this.data);
        view.method_71468("queue", WorldMarkingQueue.CODEC, (Object)this.queue);
    }
}

