/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.hideandseek.common.cca;

import com.eightsidedsquare.hideandseek.common.cca.WorldMarkingComponent;
import com.eightsidedsquare.hideandseek.common.game.challenge.Challenge;
import com.eightsidedsquare.hideandseek.common.game.hiding.BonusTime;
import com.eightsidedsquare.hideandseek.common.game.hiding.HidingOrder;
import com.eightsidedsquare.hideandseek.common.game.hiding.HidingSpotRequirement;
import com.eightsidedsquare.hideandseek.common.game.marking.WorldMarkingData;
import com.eightsidedsquare.hideandseek.common.game.player.GamePlayerManagerImpl;
import com.eightsidedsquare.hideandseek.common.game.player.GamePlayerManagerWrapper;
import com.eightsidedsquare.hideandseek.common.game.player.ServerGamePlayer;
import com.eightsidedsquare.hideandseek.common.game.powerup.Powerup;
import com.eightsidedsquare.hideandseek.common.game.powerup.PowerupHand;
import com.eightsidedsquare.hideandseek.common.game.powerup.PowerupReward;
import com.eightsidedsquare.hideandseek.common.game.question.ActiveQuestion;
import com.eightsidedsquare.hideandseek.common.game.question.Clues;
import com.eightsidedsquare.hideandseek.common.game.question.Question;
import com.eightsidedsquare.hideandseek.common.game.question.QuestionStates;
import com.eightsidedsquare.hideandseek.common.game.state.GameDimensions;
import com.eightsidedsquare.hideandseek.common.game.state.GameState;
import com.eightsidedsquare.hideandseek.common.game.state.GameStateImpl;
import com.eightsidedsquare.hideandseek.common.game.state.GameStateWrapper;
import com.eightsidedsquare.hideandseek.common.network.ActiveQuestionS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.AnnouncementS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.ChallengeStatusS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.CluesS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.EndResultsS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.HiderAnnouncementS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.HidingSpotRequirementsS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.HidingTimeS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.PowerupRewardS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.QuestionStatesS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.ResetGameS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.SeekerQuestionCooldownS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.SeekerTpCooldownS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.SyncGameStateS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.SyncPowerupsS2CPayload;
import com.eightsidedsquare.hideandseek.core.ModComponents;
import com.eightsidedsquare.hideandseek.core.ModRegistries;
import com.eightsidedsquare.hideandseek.core.ModSounds;
import com.eightsidedsquare.zine.common.util.codec.DataHelper;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2265;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2709;
import net.minecraft.class_2784;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3544;
import net.minecraft.class_4076;
import net.minecraft.class_5454;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_8710;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.ladysnake.cca.api.v3.component.Component;
import org.ladysnake.cca.api.v3.component.tick.ServerTickingComponent;

public class GameComponent
implements Component,
ServerTickingComponent,
GamePlayerManagerWrapper<ServerGamePlayer>,
GameStateWrapper {
    private static final DataHelper<GameComponent> DATA_HELPER;
    private static final Int2ObjectMap<class_1799> SEEKER_EQUIPMENT;
    private static final int DEFAULT_SEEKER_TP_COOLDOWN = 300;
    private final class_1937 world;
    private final List<class_6880<Challenge>> activeChallenges = new ArrayList<class_6880<Challenge>>();
    private final List<Powerup> powerupPool = new ArrayList<Powerup>();
    private GamePlayerManagerImpl<ServerGamePlayer> playerManager = new GamePlayerManagerImpl();
    private GameState gameState = new GameStateImpl();
    private Clues clues = new Clues();
    private QuestionStates questionStates = new QuestionStates();
    private PowerupHand hiderPowerups = new PowerupHand();
    private HidingOrder hidingOrder = new HidingOrder();
    private int intermissionTicks;
    private int seekerTpCooldown;
    private int seekerQuestionCooldown;
    private int defaultSize = 64;
    private boolean nextQuestionCanceled;
    @Nullable
    private ActiveQuestion activeQuestion;
    @Nullable
    private class_2561 incomingClue;
    private class_2784.class_5200 worldBorderCache = class_2784.field_24122;
    @Nullable
    private BonusTime bonusTime;
    @Nullable
    private class_2265 hiderTpTarget;
    @Nullable
    private class_2265 seekersTpTarget;
    private int hiderRequirementCooldown;

    public GameComponent(class_1937 world) {
        this.world = world;
    }

    @Nullable
    public static GameComponent get(class_1937 world) {
        if (world.method_27983().equals(class_1937.field_25179)) {
            return (GameComponent)ModComponents.GAME.get((Object)world);
        }
        return null;
    }

    private static class_1799 unbreakableStack(class_1792 item) {
        class_1799 stack = item.method_7854();
        stack.method_57381(class_9334.field_50072);
        return stack;
    }

    public Clues getClues() {
        return this.clues;
    }

    public void setClues(Clues clues) {
        this.clues = clues;
    }

    public QuestionStates getQuestionStates() {
        return this.questionStates;
    }

    public void setQuestionStates(QuestionStates questionStates) {
        this.questionStates = questionStates;
    }

    public PowerupHand getHiderPowerups() {
        return this.hiderPowerups;
    }

    public void setHiderPowerups(PowerupHand hiderPowerups) {
        this.hiderPowerups = hiderPowerups;
    }

    public HidingOrder getHidingOrder() {
        return this.hidingOrder;
    }

    public void setHidingOrder(HidingOrder hidingOrder) {
        this.hidingOrder = hidingOrder;
    }

    @Nullable
    public ActiveQuestion getActiveQuestion() {
        return this.activeQuestion;
    }

    public void setActiveQuestion(@Nullable ActiveQuestion activeQuestion) {
        this.activeQuestion = activeQuestion;
    }

    @Nullable
    public class_2561 getIncomingClue() {
        return this.incomingClue;
    }

    public void setIncomingClue(@Nullable class_2561 incomingClue) {
        this.incomingClue = incomingClue;
    }

    public class_2784.class_5200 getWorldBorderCache() {
        return this.worldBorderCache;
    }

    public void setWorldBorderCache(class_2784.class_5200 worldBorderCache) {
        this.worldBorderCache = worldBorderCache;
    }

    @Nullable
    public BonusTime getBonusTime() {
        return this.bonusTime;
    }

    public void setBonusTime(@Nullable BonusTime bonusTime) {
        this.bonusTime = bonusTime;
    }

    public List<class_6880<Challenge>> getActiveChallenges() {
        return this.activeChallenges;
    }

    public void addChallenge(class_6880<Challenge> challenge) {
        if (!this.activeChallenges.contains(challenge)) {
            this.activeChallenges.add(challenge);
            this.sendToAll(ChallengeStatusS2CPayload.builder().add(challenge).build());
        }
    }

    public void startChallenge(class_6880<Challenge> challenge) {
        if (!this.activeChallenges.contains(challenge)) {
            this.activeChallenges.add(challenge);
            this.sendToAll(ChallengeStatusS2CPayload.builder().start(challenge).build());
        }
    }

    public void removeChallenge(class_6880<Challenge> challenge) {
        if (this.activeChallenges.remove(challenge)) {
            this.sendToAll(ChallengeStatusS2CPayload.builder().remove(challenge).build());
        }
    }

    public void completeChallenge(class_6880<Challenge> challenge) {
        if (this.activeChallenges.remove(challenge)) {
            this.sendToAll(ChallengeStatusS2CPayload.builder().complete(challenge).build());
            this.sendToSeekers(new AnnouncementS2CPayload((class_2561)class_2561.method_43471((String)"hideandseek.challenge.complete"), 0.0f, 2.0f));
        }
    }

    private Powerup drawPowerup(class_5819 random) {
        if (this.powerupPool.isEmpty()) {
            for (Powerup powerup : ModRegistries.POWERUP) {
                for (int i = 0; i < powerup.weight(); ++i) {
                    this.powerupPool.add(powerup);
                }
            }
        }
        return this.powerupPool.remove(random.method_43048(this.powerupPool.size()));
    }

    private List<Powerup> drawPowerups(int count, class_5819 random) {
        ArrayList<Powerup> powerups = new ArrayList<Powerup>();
        for (int i = 0; i < count; ++i) {
            powerups.add(this.drawPowerup(random));
        }
        return powerups;
    }

    @Override
    public GameState getGameState() {
        return this.gameState;
    }

    public void setGameState(GameState gameState) {
        this.gameState = gameState;
    }

    @Override
    public GamePlayerManagerImpl<ServerGamePlayer> getPlayerManager() {
        return this.playerManager;
    }

    public void setPlayerManager(GamePlayerManagerImpl<ServerGamePlayer> playerManager) {
        this.playerManager = playerManager;
    }

    public int getIntermissionTicks() {
        return this.intermissionTicks;
    }

    public void setIntermissionTicks(int intermissionTicks) {
        this.intermissionTicks = intermissionTicks;
    }

    public int getSeekerTpCooldown() {
        return this.seekerTpCooldown;
    }

    public void setSeekerTpCooldown(int seekerTpCooldown) {
        this.seekerTpCooldown = seekerTpCooldown;
    }

    public int getSeekerQuestionCooldown() {
        return this.seekerQuestionCooldown;
    }

    public void setSeekerQuestionCooldown(int seekerQuestionCooldown) {
        this.seekerQuestionCooldown = seekerQuestionCooldown;
    }

    public int getDefaultSize() {
        return this.defaultSize;
    }

    public void setDefaultSize(int defaultSize) {
        this.defaultSize = defaultSize;
    }

    public boolean isNextQuestionCanceled() {
        return this.nextQuestionCanceled;
    }

    public void setNextQuestionCanceled(boolean nextQuestionCanceled) {
        this.nextQuestionCanceled = nextQuestionCanceled;
    }

    public List<Powerup> getPowerupPool() {
        return this.powerupPool;
    }

    @Override
    public void addPlayer(class_3222 player) {
        this.addPlayer(new ServerGamePlayer(player));
    }

    @Override
    public void disconnectPlayer(UUID uuid) {
        if (this.playerManager.hider != null && ((ServerGamePlayer)this.playerManager.hider).getUuid().equals(uuid) && this.activeQuestion != null) {
            this.activeQuestion.setWaiting(true);
            this.sendToAll(ActiveQuestionS2CPayload.of(this.activeQuestion));
        }
        GamePlayerManagerWrapper.super.disconnectPlayer(uuid);
    }

    @Override
    public void setHider(@Nullable class_1657 player, boolean tickHiderTime) {
        GamePlayerManagerWrapper.super.setHider(player, tickHiderTime);
        this.sendToAll(this.playerManager.createHiderStatusPayload());
    }

    @Override
    public boolean setHiderTimeTicking(boolean tickHiderTime) {
        if (GamePlayerManagerWrapper.super.setHiderTimeTicking(tickHiderTime)) {
            this.sendToAll(this.playerManager.createHiderStatusPayload());
            return true;
        }
        return false;
    }

    @Override
    public List<ServerGamePlayer> setHidingTimes(Collection<? extends class_1657> players, IntUnaryOperator timeOperator) {
        List<ServerGamePlayer> list = GamePlayerManagerWrapper.super.setHidingTimes(players, timeOperator);
        this.sendToAll(HidingTimeS2CPayload.create(list));
        return list;
    }

    @Nullable
    public class_3222 getHider(class_3218 world) {
        return this.playerManager.hider == null ? null : (class_3222)((ServerGamePlayer)this.playerManager.hider).getPlayer(world);
    }

    public boolean isHider(class_1657 player) {
        ServerGamePlayer hider = (ServerGamePlayer)this.playerManager.hider;
        return hider != null && hider.getUuid().equals(player.method_5667());
    }

    public boolean isSeeker(class_1657 player) {
        ServerGamePlayer hider = (ServerGamePlayer)this.playerManager.hider;
        return hider != null && !hider.getUuid().equals(player.method_5667());
    }

    public void addPlayers(Collection<class_3222> players) {
        players.forEach(this::addPlayer);
        this.sendToAll(this.playerManager.createPlayerListPayload());
    }

    public void removePlayers(Collection<class_3222> players) {
        players.forEach(this::removePlayer);
        this.sendToAll(this.playerManager.createPlayerListPayload());
    }

    public void forEachSeeker(class_3218 serverWorld, Consumer<class_3222> consumer) {
        if (this.playerManager.hider == null) {
            return;
        }
        for (ServerGamePlayer gamePlayer : this.playerManager.players) {
            class_3222 player;
            if (gamePlayer.equals(this.playerManager.hider) || (player = (class_3222)gamePlayer.getPlayer(serverWorld)) == null) continue;
            consumer.accept(player);
        }
    }

    public void forEachSeeker(Consumer<class_3222> consumer) {
        class_1937 class_19372 = this.world;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            this.forEachSeeker(serverWorld, consumer);
        }
    }

    public <T extends class_8710> void sendToAll(T payload) {
        class_1937 class_19372 = this.world;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            PlayerLookup.world((class_3218)serverWorld).forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_8710)payload));
        }
    }

    public <T extends class_8710> void sendToSeekers(T payload) {
        this.forEachSeeker(player -> ServerPlayNetworking.send((class_3222)player, (class_8710)payload));
    }

    public <T extends class_8710> void sendToHider(T payload) {
        class_3218 serverWorld;
        class_3222 player;
        class_1937 class_19372;
        if (this.playerManager.hider != null && (class_19372 = this.world) instanceof class_3218 && (player = (class_3222)((ServerGamePlayer)this.playerManager.hider).getPlayer(serverWorld = (class_3218)class_19372)) != null) {
            ServerPlayNetworking.send((class_3222)player, payload);
        }
    }

    public void onPlayerJoin(class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new SyncGameStateS2CPayload(this.getGameState()));
        ServerPlayNetworking.send((class_3222)player, (class_8710)this.playerManager.createPlayerListPayload());
        ServerPlayNetworking.send((class_3222)player, (class_8710)this.questionStates.createPayload());
        ServerPlayNetworking.send((class_3222)player, (class_8710)new SeekerTpCooldownS2CPayload(this.getSeekerTpCooldown()));
        ServerPlayNetworking.send((class_3222)player, (class_8710)new SeekerQuestionCooldownS2CPayload(this.seekerQuestionCooldown));
        if (!this.activeChallenges.isEmpty()) {
            ChallengeStatusS2CPayload.Builder builder = ChallengeStatusS2CPayload.builder();
            this.activeChallenges.forEach(builder::add);
            ServerPlayNetworking.send((class_3222)player, (class_8710)builder.build());
        }
        if (!this.clues.isEmpty()) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new CluesS2CPayload(this.clues.getClues()));
        }
        if (this.isHider((class_1657)player)) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new SyncPowerupsS2CPayload(this.hiderPowerups));
            if (this.isSeekingPhase() && (this.activeQuestion == null || !this.activeQuestion.isWaitingNow())) {
                this.setHiderTimeTicking(true);
            }
            if (this.activeQuestion != null && this.activeQuestion.isWaiting() && this.activeQuestion.getQuestion().triggersAutomatically()) {
                this.activeQuestion.setWaiting(false);
                this.sendToAll(ActiveQuestionS2CPayload.of(this.activeQuestion));
            } else {
                this.sendToHider(ActiveQuestionS2CPayload.of(this.activeQuestion));
            }
        }
    }

    public void syncGameState() {
        this.sendToAll(new SyncGameStateS2CPayload(this.getGameState()));
    }

    public void tryStarting() {
        if (this.isQueueingPhase() && this.playerManager.getGamePlayerCount() >= 2) {
            this.hidingOrder = new HidingOrder(this.playerManager, this.world.field_9229);
            UUID hiderUUID = this.hidingOrder.getCurrentUUID();
            ServerGamePlayer hiderGamePlayer = (ServerGamePlayer)this.getGamePlayer(hiderUUID);
            if (hiderGamePlayer == null) {
                return;
            }
            this.setHider(hiderGamePlayer);
            this.intermissionTicks = 100;
            this.setPhase(GameState.Phase.INTERMISSION);
            this.setHiderTimeTicking(false);
            this.syncGameState();
            this.sendToAll(this.playerManager.createHiderStatusPayload());
            this.announceHider(0);
        }
    }

    public void catchHider(class_3222 player) {
        if (this.isSeekingPhase() && this.isHider((class_1657)player)) {
            int timeBonus = this.hiderPowerups.getTimeBonus();
            this.bonusTime = timeBonus == 0 ? null : new BonusTime(timeBonus, player.method_5667(), 100);
            this.intermissionTicks = this.bonusTime == null ? 200 : 300;
            this.clearPlayerInventoriesAndHunger();
            UUID nextHiderUUID = this.hidingOrder.next();
            if (nextHiderUUID == null) {
                this.endGame();
                return;
            }
            ServerGamePlayer hiderGamePlayer = (ServerGamePlayer)this.getGamePlayer(nextHiderUUID);
            if (hiderGamePlayer == null) {
                this.reset();
                return;
            }
            this.setHider(hiderGamePlayer);
            this.setPhase(GameState.Phase.INTERMISSION);
            this.setHiderTimeTicking(false);
            this.syncGameState();
            this.sendToAll(this.playerManager.createHiderStatusPayload());
            this.announceHider(this.bonusTime == null ? 100 : 200);
            this.announceHiderCaught();
            WorldMarkingComponent worldMarkingComponent = WorldMarkingComponent.get(this.world);
            if (worldMarkingComponent != null) {
                worldMarkingComponent.setData(null);
            }
            this.clues.clear();
            this.sendToAll(CluesS2CPayload.CLEAR);
            ChallengeStatusS2CPayload.Builder builder = ChallengeStatusS2CPayload.builder();
            this.activeChallenges.forEach(builder::remove);
            this.sendToAll(builder.build());
            this.activeChallenges.clear();
            this.nextQuestionCanceled = false;
            this.seekerQuestionCooldown = 0;
            this.seekerTpCooldown = 0;
            this.sendToAll(new SeekerQuestionCooldownS2CPayload(0));
            this.sendToAll(new SeekerTpCooldownS2CPayload(0));
            this.activeQuestion = null;
            this.sendToAll(ActiveQuestionS2CPayload.FORCE_CLEAR);
            this.questionStates.clear();
            this.sendToAll(QuestionStatesS2CPayload.CLEAR);
            this.hiderPowerups.clear();
            this.sendToAll(new SyncPowerupsS2CPayload(this.hiderPowerups));
        }
    }

    private void announceHiderCaught() {
        this.sendToAll(new AnnouncementS2CPayload((class_2561)class_2561.method_43471((String)"hideandseek.hider_caught"), 0.0f, 2.0f, ModSounds.HIDER_CAUGHT));
    }

    public void endGame() {
        this.announceHiderCaught();
        this.setPhase(GameState.Phase.END);
        this.setHiderTimeTicking(false);
        this.syncGameState();
        this.intermissionTicks += 100;
        EndResultsS2CPayload endResultsPayload = EndResultsS2CPayload.create(this.bonusTime == null ? 100 : 200, this);
        if (endResultsPayload != null) {
            this.sendToAll(endResultsPayload);
        }
    }

    public void announceHider(int delay) {
        if (this.playerManager.hider == null || this.getGamePlayerCount() < 2) {
            return;
        }
        ArrayList<UUID> seekers = new ArrayList<UUID>();
        for (ServerGamePlayer player : this.playerManager.players) {
            if (player.equals(this.playerManager.hider)) continue;
            seekers.add(player.getUuid());
        }
        this.sendToAll(new HiderAnnouncementS2CPayload(((ServerGamePlayer)this.playerManager.hider).getUuid(), seekers, delay));
    }

    public void startHidingPhase() {
        class_1937 class_19372;
        if (this.isIntermissionPhase() && (class_19372 = this.world) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            this.clearPlayerInventoriesAndHunger();
            this.setPhase(GameState.Phase.HIDING);
            if (this.getDimensions() == null) {
                this.calculateDimensions(serverWorld, this.playerManager.players, this.getDefaultSize());
            }
            this.syncGameState();
            GameDimensions dimensions = this.getDimensions();
            WorldMarkingComponent worldMarkingComponent = WorldMarkingComponent.get(this.world);
            this.worldBorderCache = new class_2784.class_5200(serverWorld.method_8621());
            if (dimensions != null && worldMarkingComponent != null) {
                worldMarkingComponent.setData(new WorldMarkingData(dimensions.chunkWidth(), dimensions.getOriginChunkPos()));
                Vector2d center = dimensions.getBlockCenter();
                serverWorld.method_8621().method_11978(center.x, center.y);
                serverWorld.method_8621().method_11969((double)dimensions.width());
            }
        }
    }

    private void clearPlayerInventoriesAndHunger() {
        class_1937 class_19372 = this.world;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            for (ServerGamePlayer gamePlayer : this.playerManager.players) {
                class_3222 player = (class_3222)gamePlayer.getPlayer(serverWorld);
                if (player == null) continue;
                player.method_7344().method_7585(20, 2.0f);
                player.method_6033(player.method_6063());
                this.clearPlayerInventory(player);
            }
        }
    }

    private void clearPlayerInventory(class_3222 player) {
        if (!player.method_68878()) {
            player.method_31548().method_29280(stack -> true, -1, (class_1263)player.field_7498.method_29281());
            player.field_7512.method_7623();
            player.field_7498.method_7609((class_1263)player.method_31548());
        }
    }

    public void reset() {
        class_1937 class_19372;
        this.setPhase(GameState.Phase.QUEUEING);
        this.clearPlayers();
        this.intermissionTicks = 0;
        this.seekerTpCooldown = 0;
        this.seekerQuestionCooldown = 0;
        this.gameState = new GameStateImpl();
        this.activeQuestion = null;
        this.activeChallenges.clear();
        this.powerupPool.clear();
        this.incomingClue = null;
        this.bonusTime = null;
        this.clues.clear();
        this.questionStates.clear();
        this.hiderPowerups.clear();
        this.hiderTpTarget = null;
        this.seekersTpTarget = null;
        this.sendToAll(ResetGameS2CPayload.INSTANCE);
        WorldMarkingComponent worldMarkingComponent = WorldMarkingComponent.get(this.world);
        if (worldMarkingComponent != null) {
            worldMarkingComponent.setData(null);
        }
        if (this.worldBorderCache != null && (class_19372 = this.world) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_8621().method_17905(this.worldBorderCache);
        }
        this.worldBorderCache = class_2784.field_24122;
    }

    public void serverTick() {
        this.playerManager.tick();
        if (this.isIntermissionPhase() && this.intermissionTicks > 0 && --this.intermissionTicks == 0) {
            this.startHidingPhase();
        }
        if ((this.isIntermissionPhase() || this.isEndPhase()) && this.bonusTime != null && this.bonusTime.tick()) {
            ServerGamePlayer hiderGamePlayer = (ServerGamePlayer)this.getGamePlayer(this.bonusTime.getHider());
            int base = hiderGamePlayer == null ? 0 : hiderGamePlayer.getHidingTime();
            this.setHidingTime(this.bonusTime.getHider(), base + this.bonusTime.getTime());
            this.sendToAll(((GamePlayerManagerImpl)this.getPlayerManager()).createPlayerListPayload());
            String timeString = class_3544.method_15439((int)this.bonusTime.getTime(), (float)this.world.method_54719().method_54748());
            this.sendToAll(new AnnouncementS2CPayload((class_2561)class_2561.method_43470((String)("+" + timeString)), -10.0f, 2.0f, ModSounds.TIME_BONUS));
            this.sendToAll(new AnnouncementS2CPayload((class_2561)class_2561.method_43471((String)"hideandseek.time_bonus"), 10.0f, 1.0f));
            this.bonusTime = null;
        }
        if (this.isEndPhase() && this.intermissionTicks > 0 && --this.intermissionTicks == 0) {
            this.reset();
        }
        class_3222 hiderPlayer = this.getHider((class_3218)this.world);
        if (this.isHidingPhase() && hiderPlayer != null) {
            if (--this.hiderRequirementCooldown <= 0) {
                this.hiderRequirementCooldown = 5;
                this.sendToHider(HidingSpotRequirementsS2CPayload.create(HidingSpotRequirement.DEFAULT, hiderPlayer));
            }
            if (this.hiderTpTarget != null) {
                this.tryTeleportHider(hiderPlayer, this.hiderTpTarget.comp_638(), this.hiderTpTarget.comp_639());
            }
        }
        if (this.isSeekingPhase()) {
            if (this.seekerTpCooldown > 0) {
                --this.seekerTpCooldown;
            }
            if (this.seekerQuestionCooldown > 0) {
                --this.seekerQuestionCooldown;
            }
            if (hiderPlayer != null && this.activeQuestion != null) {
                if (this.activeQuestion.tick()) {
                    this.onQuestionTimeout();
                } else if (this.playerManager.tickHiderTime && !this.activeQuestion.isCanceled() && this.activeQuestion.isWaitingNow() && !this.activeQuestion.getQuestion().triggersAutomatically()) {
                    this.setHiderTimeTicking(false);
                }
            }
            if (this.seekersTpTarget != null) {
                this.tryTeleportSeekers(this.seekersTpTarget.comp_638(), this.seekersTpTarget.comp_639());
            }
        }
    }

    private void onQuestionTimeout() {
        WorldMarkingComponent worldMarkingComponent;
        class_3222 hiderPlayer;
        class_1937 class_19372;
        if (this.activeQuestion == null || !((class_19372 = this.world) instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        Question question = this.activeQuestion.getQuestion();
        this.sendToAll(new QuestionStatesS2CPayload(question, this.questionStates.increment(question)));
        boolean canceled = this.activeQuestion.isCanceled();
        this.activeQuestion = null;
        this.sendToAll(ActiveQuestionS2CPayload.of(null));
        if (canceled) {
            this.incomingClue = null;
            return;
        }
        if (this.incomingClue != null) {
            this.clues.addClue(this.incomingClue);
            this.sendToAll(new CluesS2CPayload(this.incomingClue));
            this.incomingClue = null;
        }
        if ((hiderPlayer = this.getHider(serverWorld)) != null) {
            this.setHiderTimeTicking(true);
            this.clearPlayerInventory(hiderPlayer);
            this.rewardHider(hiderPlayer, question, PowerupReward.Cause.QUESTION);
        }
        if ((worldMarkingComponent = WorldMarkingComponent.get((class_1937)serverWorld)) != null) {
            worldMarkingComponent.getQueue().applyAll(worldMarkingComponent);
        }
    }

    public void rewardHider(class_3222 player, Question question, PowerupReward.Cause cause) {
        Question.Category category = question.getCategory();
        int multiplier = class_3532.method_15340((int)this.getQuestionStates().getTimesAsked(question), (int)1, (int)2);
        this.rewardHider(player, category.getDrawCount() * multiplier, category.getPickCount() * multiplier, cause);
    }

    public void rewardHider(class_3222 player, int draw, int pick, PowerupReward.Cause cause) {
        PowerupReward reward = new PowerupReward(this.drawPowerups(draw, player.method_59922()), pick);
        this.hiderPowerups.getRewardQueue().add(reward);
        this.sendToHider(new PowerupRewardS2CPayload(reward, cause));
    }

    public void playPowerup(class_3222 player, Powerup powerup) {
        if (this.isHider((class_1657)player) && this.hiderPowerups.play(powerup, player.method_51469(), this)) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new SyncPowerupsS2CPayload(this.hiderPowerups));
        }
    }

    public void pickPowerups(class_3222 player, List<Powerup> picked, List<Powerup> discarded) {
        if (this.isHider((class_1657)player) && this.hiderPowerups.pick(picked, discarded)) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new SyncPowerupsS2CPayload(this.hiderPowerups));
        }
    }

    public void askQuestion(class_3222 source, Question question) {
        if (this.activeQuestion != null || !this.isSeeker((class_1657)source)) {
            return;
        }
        class_3222 hiderPlayer = this.getHider(source.method_51469());
        if (hiderPlayer == null) {
            return;
        }
        this.setActiveQuestion(new ActiveQuestion(question, this.isNextQuestionCanceled()));
        this.setNextQuestionCanceled(false);
        this.sendToAll(ActiveQuestionS2CPayload.of(this.activeQuestion, source.method_5667()));
        this.seekerQuestionCooldown = 300;
        this.sendToAll(new SeekerQuestionCooldownS2CPayload(this.seekerQuestionCooldown));
        if (!this.activeQuestion.isCanceled()) {
            question.applyHiderModifier(hiderPlayer, this);
        }
        this.incomingClue = question.getResponse(hiderPlayer, this, source);
        WorldMarkingComponent worldMarkingComponent = WorldMarkingComponent.get(this.world);
        if (worldMarkingComponent != null && !this.activeQuestion.isCanceled()) {
            question.applyMarkingModifier(hiderPlayer, worldMarkingComponent, source);
        }
    }

    public void tryTeleportHider(class_3222 player, int x, int z) {
        if (this.isHidingPhase() && this.isHider((class_1657)player)) {
            if (this.getDimensions() == null || !this.getDimensions().containsBlock(x, z)) {
                return;
            }
            class_1923 chunkPos = new class_1923(class_4076.method_18675((int)x), class_4076.method_18675((int)z));
            class_3218 serverWorld = (class_3218)this.world;
            if (serverWorld.method_8393(chunkPos.field_9181, chunkPos.field_9180)) {
                int y = serverWorld.method_8624(class_2902.class_2903.field_13197, x, z);
                player.method_61275(new class_5454(serverWorld, new class_243((double)x + 0.5, (double)y, (double)z + 0.5), class_243.field_1353, 0.0f, 0.0f, class_2709.method_63641((Set[])new Set[]{class_2709.field_40711, class_2709.field_54094}), class_5454.field_52245));
                serverWorld.method_54762(null, (double)x + 0.5, (double)y, (double)z + 0.5, class_3417.field_46945, class_3419.field_15248);
                this.hiderTpTarget = null;
            } else {
                serverWorld.method_14178().method_66009(class_3230.field_55599, chunkPos, 2);
                this.hiderTpTarget = new class_2265(x, z);
            }
        }
    }

    public void tryTeleportSeekers(class_3222 player, int x, int z) {
        if (this.isSeeker((class_1657)player)) {
            this.tryTeleportSeekers(x, z);
        }
    }

    private void tryTeleportSeekers(int x, int z) {
        if (this.isSeekingPhase() && this.activeChallenges.isEmpty() && this.seekerTpCooldown <= 0) {
            class_1923 chunkPos = new class_1923(class_4076.method_18675((int)x), class_4076.method_18675((int)z));
            class_3218 serverWorld = (class_3218)this.world;
            if (serverWorld.method_8393(chunkPos.field_9181, chunkPos.field_9180)) {
                int y = serverWorld.method_8624(class_2902.class_2903.field_13197, x, z);
                this.forEachSeeker(seekerPlayer -> seekerPlayer.method_61275(new class_5454(serverWorld, new class_243((double)x + 0.5, (double)y, (double)z + 0.5), class_243.field_1353, 0.0f, 0.0f, class_2709.method_63641((Set[])new Set[]{class_2709.field_40711, class_2709.field_54094}), class_5454.field_52245)));
                serverWorld.method_54762(null, (double)x + 0.5, (double)y, (double)z + 0.5, class_3417.field_46945, class_3419.field_15248);
                this.seekersTpTarget = null;
                this.setSeekerTpCooldown(300);
                this.sendToAll(new SeekerTpCooldownS2CPayload(this.getSeekerTpCooldown()));
            } else {
                serverWorld.method_14178().method_66009(class_3230.field_55599, chunkPos, 2);
                this.seekersTpTarget = new class_2265(x, z);
            }
        }
    }

    public void tryAcceptingHidingSpot(class_3222 player) {
        class_1937 class_19372;
        if (this.isHidingPhase() && this.isHider((class_1657)player) && (class_19372 = this.world) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            if (!HidingSpotRequirement.DEFAULT.stream().allMatch(requirement -> requirement.predicate().test(player))) {
                return;
            }
            this.clearPlayerInventoriesAndHunger();
            this.setPhase(GameState.Phase.SEEKING);
            this.setHiderTimeTicking(true);
            this.syncGameState();
            this.sendToHider(HidingSpotRequirementsS2CPayload.EMPTY);
            this.forEachSeeker(serverWorld, seekerPlayer -> SEEKER_EQUIPMENT.forEach((slotId, stack) -> seekerPlayer.method_31548().method_5447(slotId.intValue(), stack.method_7972())));
            this.sendToSeekers(new AnnouncementS2CPayload((class_2561)class_2561.method_43471((String)"hideandseek.seeking_phase_announcement.seeker"), -10.0f, 2.0f, ModSounds.HIDER_HIDING));
            this.sendToSeekers(new AnnouncementS2CPayload((class_2561)class_2561.method_43471((String)"hideandseek.seeking_phase_announcement_subtitle.seeker"), 10.0f, 1.0f));
            this.sendToHider(new AnnouncementS2CPayload((class_2561)class_2561.method_43471((String)"hideandseek.seeking_phase_announcement.hider"), -10.0f, 2.0f, ModSounds.HIDER_HIDING));
            this.sendToHider(new AnnouncementS2CPayload((class_2561)class_2561.method_43471((String)"hideandseek.seeking_phase_announcement_subtitle.hider"), 10.0f, 1.0f));
        }
    }

    public void triggerActiveQuestion() {
        if (this.activeQuestion != null && this.activeQuestion.isWaiting()) {
            this.activeQuestion.setWaiting(false);
            this.sendToAll(ActiveQuestionS2CPayload.of(this.activeQuestion));
        }
    }

    public void readData(class_11368 view) {
        DATA_HELPER.read(view, (Object)this);
    }

    public void writeData(class_11372 view) {
        DATA_HELPER.write(view, (Object)this);
    }

    private static /* synthetic */ HidingOrder lambda$static$5(GameComponent component) {
        return new HidingOrder();
    }

    private static /* synthetic */ PowerupHand lambda$static$4(GameComponent component) {
        return new PowerupHand();
    }

    private static /* synthetic */ QuestionStates lambda$static$3(GameComponent component) {
        return new QuestionStates();
    }

    private static /* synthetic */ Clues lambda$static$2(GameComponent component) {
        return new Clues();
    }

    private static /* synthetic */ GameState lambda$static$1(GameComponent gameComponent) {
        return new GameStateImpl();
    }

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 0 out of bounds for length 0
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:368)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

