/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.hideandseek.client.util;

import com.eightsidedsquare.hideandseek.client.texture.MinimapTextureManager;
import com.eightsidedsquare.hideandseek.common.game.marking.ChunkMarking;
import com.eightsidedsquare.hideandseek.common.game.marking.WorldMarkingData;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientWorldEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginConnectionEvents;
import net.minecraft.class_1923;
import net.minecraft.class_310;
import net.minecraft.class_4076;
import net.minecraft.class_635;
import net.minecraft.class_638;
import net.minecraft.class_761;
import org.jetbrains.annotations.Nullable;

public class ClientWorldMarkings
implements ClientWorldEvents.AfterClientWorldChange,
ClientLoginConnectionEvents.Init,
ClientLoginConnectionEvents.Disconnect {
    public static final ClientWorldMarkings INSTANCE = new ClientWorldMarkings();
    @Nullable
    private WorldMarkingData data;

    private ClientWorldMarkings() {
    }

    public void registerEvents() {
        ClientWorldEvents.AFTER_CLIENT_WORLD_CHANGE.register((Object)this);
        ClientLoginConnectionEvents.INIT.register((Object)this);
        ClientLoginConnectionEvents.DISCONNECT.register((Object)this);
    }

    @Nullable
    public WorldMarkingData getData() {
        return this.data;
    }

    public boolean isMarked(int x, int z) {
        if (this.data == null) {
            return false;
        }
        return this.data.isMarked(x, z);
    }

    public void set(@Nullable WorldMarkingData data) {
        WorldMarkingData prevData = this.data;
        this.data = data;
        this.scheduleChunkRenders(this.data);
        this.scheduleChunkRenders(prevData);
        MinimapTextureManager.INSTANCE.uploadMarkingTexture();
    }

    public void set(class_1923 pos, ChunkMarking marking) {
        if (this.data == null) {
            return;
        }
        this.data.setMarking(pos, marking);
        this.scheduleChunkRenders(pos.field_9181, pos.field_9180);
    }

    private void scheduleChunkRenders(@Nullable WorldMarkingData data) {
        if (data != null) {
            class_1923 origin = data.getOrigin();
            int maxChunkX = origin.field_9181 + data.getSize();
            int maxChunkZ = origin.field_9180 + data.getSize();
            for (int chunkX = origin.field_9181; chunkX < maxChunkX; ++chunkX) {
                for (int chunkZ = origin.field_9180; chunkZ < maxChunkZ; ++chunkZ) {
                    this.scheduleChunkRenders(chunkX, chunkZ);
                }
            }
        }
    }

    private void scheduleChunkRenders(int chunkX, int chunkZ) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        int minChunkY = class_4076.method_18675((int)world.method_31607());
        int maxChunkY = class_4076.method_18675((int)world.method_31600());
        class_761 worldRenderer = class_310.method_1551().field_1769;
        for (int chunkY = minChunkY; chunkY <= maxChunkY; ++chunkY) {
            worldRenderer.method_8571(chunkX, chunkY, chunkZ);
            MinimapTextureManager.INSTANCE.updateMarkingTexture(chunkX, chunkZ);
        }
    }

    public void clear() {
        this.data = null;
    }

    public void afterWorldChange(class_310 client, class_638 world) {
        this.clear();
    }

    public void onLoginDisconnect(class_635 handler, class_310 client) {
        this.clear();
    }

    public void onLoginStart(class_635 handler, class_310 client) {
        this.clear();
    }
}

