/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.hideandseek.client.texture;

import com.eightsidedsquare.hideandseek.client.layer.GameLayer;
import com.eightsidedsquare.hideandseek.client.texture.BlockColorLoader;
import com.eightsidedsquare.hideandseek.client.util.ClientWorldMarkings;
import com.eightsidedsquare.hideandseek.common.game.marking.ChunkMarking;
import com.eightsidedsquare.hideandseek.common.game.marking.WorldMarkingData;
import com.eightsidedsquare.hideandseek.common.game.state.GameDimensions;
import com.eightsidedsquare.hideandseek.core.ModInit;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientChunkEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginConnectionEvents;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5742;
import net.minecraft.class_635;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

public class MinimapTextureManager
implements AutoCloseable,
ClientLoginConnectionEvents.Init,
ClientLoginConnectionEvents.Disconnect,
ClientChunkEvents.Load,
ClientChunkEvents.Unload,
ClientTickEvents.EndWorldTick {
    private static final int REFRESH_INTERVAL = 20;
    private static final int MARKING_COLOR = -872415232;
    public static final class_2960 TERRAIN_TEXTURE = ModInit.id("minimap_terrain");
    public static final class_2960 MARKING_TEXTURE = ModInit.id("minimap_marking");
    public static final MinimapTextureManager INSTANCE = new MinimapTextureManager();
    private final LongSet loadedChunks = new LongOpenHashSet();
    private final LongSet recentlyLoadedChunks = new LongOpenHashSet();
    @Nullable
    private class_1043 terrainTexture;
    @Nullable
    private class_1043 markingTexture;
    private int refreshTime = 20;

    private MinimapTextureManager() {
    }

    public void registerEvents() {
        ClientLoginConnectionEvents.INIT.register((Object)this);
        ClientLoginConnectionEvents.DISCONNECT.register((Object)this);
        ClientChunkEvents.CHUNK_LOAD.register((Object)this);
        ClientChunkEvents.CHUNK_UNLOAD.register((Object)this);
        ClientTickEvents.END_WORLD_TICK.register((Object)this);
    }

    private void clear() {
        this.loadedChunks.clear();
        this.recentlyLoadedChunks.clear();
        if (this.terrainTexture != null) {
            this.terrainTexture.close();
            this.terrainTexture = null;
        }
        if (this.markingTexture != null) {
            this.markingTexture.close();
            this.markingTexture = null;
        }
    }

    public void resetTexture() {
        this.recentlyLoadedChunks.clear();
        this.recentlyLoadedChunks.addAll((LongCollection)this.loadedChunks);
        GameDimensions dimensions = GameLayer.INSTANCE.getDimensions();
        if (dimensions == null) {
            return;
        }
        this.terrainTexture = new class_1043(() -> "Minimap Terrain", dimensions.biomeWidth(), dimensions.biomeWidth(), true);
        class_310.method_1551().method_1531().method_4616(TERRAIN_TEXTURE, (class_1044)this.terrainTexture);
        this.markingTexture = new class_1043(() -> "Minimap Marking", dimensions.biomeWidth(), dimensions.biomeWidth(), true);
        class_310.method_1551().method_1531().method_4616(MARKING_TEXTURE, (class_1044)this.markingTexture);
    }

    private boolean updateTerrainTexture(class_638 world, class_1923 chunkPos, int width, int originX, int originZ, class_1011 image, class_2338.class_2339 mutable) {
        if (this.terrainTexture == null) {
            return false;
        }
        class_2791 chunk = world.method_8402(chunkPos.field_9181, chunkPos.field_9180, class_2806.field_12794, false);
        if (chunk == null) {
            return false;
        }
        int biomeX1 = Math.max(originX, class_5742.method_33102((int)chunkPos.field_9181));
        int biomeZ1 = Math.max(originZ, class_5742.method_33102((int)chunkPos.field_9180));
        int biomeX2 = Math.min(originX + width, class_5742.method_33102((int)(chunkPos.field_9181 + 1)));
        int biomeZ2 = Math.min(originZ + width, class_5742.method_33102((int)(chunkPos.field_9180 + 1)));
        for (int biomeX = biomeX1; biomeX < biomeX2; ++biomeX) {
            for (int biomeZ = biomeZ1; biomeZ < biomeZ2; ++biomeZ) {
                int blockX = class_5742.method_33101((int)biomeX) + 1;
                int blockZ = class_5742.method_33101((int)biomeZ) + 1;
                int x = biomeX - originX;
                int z = biomeZ - originZ;
                int topY = world.method_8624(class_2902.class_2903.field_13202, blockX, blockZ);
                int blockColor = BlockColorLoader.INSTANCE.get(world.method_8320((class_2338)mutable.method_10103(blockX, topY - 1, blockZ)), (class_6880<class_1959>)chunk.method_16359(biomeX, class_5742.method_33100((int)topY), biomeZ));
                int grade = 0;
                for (class_2350 direction : class_2350.class_2353.field_11062) {
                    int neighborY = world.method_8624(class_2902.class_2903.field_13202, blockX + direction.method_10148(), blockZ + direction.method_10165());
                    if (neighborY >= topY) continue;
                    switch (direction) {
                        case field_11043: {
                            grade += 2;
                            break;
                        }
                        case field_11035: {
                            grade -= 2;
                            break;
                        }
                        case field_11039: {
                            ++grade;
                            break;
                        }
                        case field_11034: {
                            --grade;
                        }
                    }
                }
                if (grade != 0) {
                    image.method_61941(x, z, class_9848.method_61319((float)Math.abs((float)grade * 0.05f), (int)blockColor, (int)(grade > 0 ? -1 : -16777216)));
                    continue;
                }
                image.method_61941(x, z, blockColor);
            }
        }
        return true;
    }

    public void updateTerrainTexture(class_638 world) {
        class_2338.class_2339 mutable;
        int originZ;
        int originX;
        if (this.recentlyLoadedChunks.isEmpty()) {
            return;
        }
        GameDimensions dimensions = GameLayer.INSTANCE.getDimensions();
        if (this.terrainTexture == null || dimensions == null) {
            return;
        }
        class_1011 image = this.terrainTexture.method_4525();
        if (image == null) {
            return;
        }
        int width = dimensions.biomeWidth();
        if (this.recentlyLoadedChunks.removeIf(arg_0 -> this.lambda$updateTerrainTexture$2(world, width, originX = dimensions.biomeX1(), originZ = dimensions.biomeZ1(), image, mutable = new class_2338.class_2339(), arg_0))) {
            this.terrainTexture.method_4524();
        }
    }

    public void updateMarkingTexture(int chunkX, int chunkZ) {
        if (this.markingTexture == null) {
            return;
        }
        WorldMarkingData data = ClientWorldMarkings.INSTANCE.getData();
        if (data == null) {
            return;
        }
        class_1011 image = this.markingTexture.method_4525();
        if (image == null) {
            return;
        }
        int chunkRelativeX = data.getChunkRelativeX(chunkX);
        int chunkRelativeZ = data.getChunkRelativeZ(chunkZ);
        ChunkMarking marking = data.getMarking(chunkRelativeX, chunkRelativeZ);
        int biomeRelativeX = class_5742.method_33102((int)chunkRelativeX);
        int biomeRelativeZ = class_5742.method_33102((int)chunkRelativeZ);
        for (int biomeX = 0; biomeX < 4; ++biomeX) {
            for (int biomeZ = 0; biomeZ < 4; ++biomeZ) {
                image.method_61941(biomeRelativeX + biomeX, biomeRelativeZ + biomeZ, marking.isBiomeSectionFullyMarked(biomeX, biomeZ) ? -872415232 : 0);
            }
        }
    }

    public void uploadMarkingTexture() {
        if (this.markingTexture != null) {
            this.markingTexture.method_4524();
        }
    }

    @Override
    public void close() {
        this.clear();
    }

    public void onLoginDisconnect(class_635 handler, class_310 client) {
        this.clear();
    }

    public void onLoginStart(class_635 handler, class_310 client) {
        this.clear();
    }

    public void onEndTick(class_638 world) {
        if (--this.refreshTime == 0) {
            this.refreshTime = 20;
            this.updateTerrainTexture(world);
        }
    }

    public void onChunkLoad(class_638 world, class_2818 chunk) {
        this.loadedChunks.add(chunk.method_12004().method_8324());
        this.recentlyLoadedChunks.add(chunk.method_12004().method_8324());
    }

    public void onChunkUnload(class_638 world, class_2818 chunk) {
        this.loadedChunks.remove(chunk.method_12004().method_8324());
        this.recentlyLoadedChunks.remove(chunk.method_12004().method_8324());
    }

    private /* synthetic */ boolean lambda$updateTerrainTexture$2(class_638 world, int width, int originX, int originZ, class_1011 image, class_2338.class_2339 mutable, long l) {
        return this.updateTerrainTexture(world, new class_1923(l), width, originX, originZ, image, mutable);
    }
}

