/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.hideandseek.client.texture;

import com.eightsidedsquare.hideandseek.core.ModInit;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_10716;
import net.minecraft.class_1087;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2464;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_6880;
import net.minecraft.class_773;
import net.minecraft.class_7764;
import net.minecraft.class_7923;
import net.minecraft.class_9848;

public class BlockColorLoader
implements SimpleSynchronousResourceReloadListener {
    private static final class_2960 ID = ModInit.id("block_color_loader");
    private final Map<class_2248, ColorGetter> colors = new Object2ObjectOpenHashMap();
    public static final BlockColorLoader INSTANCE = new BlockColorLoader();

    private BlockColorLoader() {
    }

    public class_2960 getFabricId() {
        return ID;
    }

    public void registerEvents() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)this);
    }

    public int get(class_2680 state, class_6880<class_1959> biome) {
        return this.get(state.method_26204(), biome);
    }

    public int get(class_2248 block, class_6880<class_1959> biome) {
        ColorGetter colorGetter = this.colors.get(block);
        if (colorGetter == null) {
            return -1;
        }
        return colorGetter.getColor(biome);
    }

    public void method_14491(class_3300 manager) {
        this.colors.clear();
        class_773 blockModels = class_310.method_1551().method_1554().method_4743();
        for (class_2248 block : class_7923.field_41175) {
            class_2680 state = block.method_9564();
            if (block == class_2246.field_10219 || block == class_2246.field_10214 || block == class_2246.field_10313 || block == class_2246.field_10479 || block == class_2246.field_10112 || block == class_2246.field_56454) {
                this.colors.put(block, class_1959::method_66386);
                continue;
            }
            if (block == class_2246.field_55742) {
                this.colors.put(block, class_1959::method_68145);
                continue;
            }
            if (block instanceof class_10716 || block == class_2246.field_10597) {
                this.colors.put(block, class_1959::method_8698);
                continue;
            }
            if (block == class_2246.field_10382 || block == class_2246.field_10422) {
                this.colors.put(block, class_1959::method_8687);
                continue;
            }
            if (block == class_2246.field_10164) {
                this.colors.put(block, biome -> -6743808);
                continue;
            }
            if (block.method_9604(state) != class_2464.field_11458) continue;
            class_1087 model = blockModels.method_3335(block.method_9564());
            class_7764 contents = model.method_68511().method_45851();
            try {
                int argb = BlockColorLoader.getAverageColor(contents.field_40539.method_48463());
                this.colors.put(block, biome -> argb);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    private static int getAverageColor(int[] data) {
        int size = 0;
        int r = 0;
        int g = 0;
        int b = 0;
        for (int abgr : data) {
            if (class_9848.method_61320((int)abgr) == 0) continue;
            ++size;
            r += class_9848.method_61331((int)abgr);
            g += class_9848.method_61329((int)abgr);
            b += class_9848.method_61327((int)abgr);
        }
        r = r / size & 0xFF;
        g = g / size & 0xFF;
        b = b / size & 0xFF;
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    @FunctionalInterface
    public static interface ColorGetter {
        public int getColor(class_1959 var1);

        default public int getColor(class_6880<class_1959> biome) {
            return this.getColor((class_1959)biome.comp_349()) | 0xFF000000;
        }
    }
}

