/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.hideandseek.client.screen;

import com.eightsidedsquare.hideandseek.client.layer.GameLayer;
import com.eightsidedsquare.hideandseek.client.screen.GameScreen;
import com.eightsidedsquare.hideandseek.client.screen.MinimapWidget;
import com.eightsidedsquare.hideandseek.client.screen.QuestionWidget;
import com.eightsidedsquare.hideandseek.common.game.question.Clues;
import com.eightsidedsquare.hideandseek.common.game.question.Question;
import com.eightsidedsquare.hideandseek.common.network.AskQuestionC2SPayload;
import com.eightsidedsquare.hideandseek.core.ModRegistries;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3872;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_474;
import net.minecraft.class_525;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_7919;
import net.minecraft.class_8027;
import net.minecraft.class_8030;
import net.minecraft.class_8087;
import net.minecraft.class_8088;
import net.minecraft.class_8089;
import net.minecraft.class_8132;
import net.minecraft.class_8662;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;

public class SeekerSeekingScreen
extends GameScreen {
    private static final class_2561 TITLE_TEXT = class_2561.method_43471((String)"hideandseek.seeker_seeking.title");
    private static final class_2561 MINIMAP_TAB_TITLE_TEXT = class_2561.method_43471((String)"hideandseek.seeker_seeking.tab.minimap");
    private static final class_2561 CLUES_TAB_TITLE_TEXT = class_2561.method_43471((String)"hideandseek.seeker_seeking.tab.clues");
    private static final class_2561 QUESTIONS_TAB_TITLE_TEXT = class_2561.method_43471((String)"hideandseek.seeker_seeking.tab.questions");
    private static final class_2561[] NO_CLUES_TEXT = new class_2561[]{class_2561.method_43471((String)"hideandseek.seeker_seeking.no_clues.0"), class_2561.method_43471((String)"hideandseek.seeker_seeking.no_clues.1")};
    private static final int CLUES_MAX_WIDTH = 116;
    private static final int CLUES_MAX_HEIGHT = 152;
    private static final int CLUES_MARGIN = 4;
    private static final String BULLET_POINT = "\u2022";
    private static final BiConsumer<class_339, class_8030> CENTERED_POSITIONER = (widget, screenRect) -> {
        widget.method_46421(screenRect.method_48254(class_8027.field_41822) - widget.method_25368() / 2);
        widget.method_46419(screenRect.method_48254(class_8027.field_41823) - widget.method_25364() / 2);
    };
    private static int lastTab = 0;
    private final class_8088 tabManager = new class_8088(x$0 -> {
        class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
    }, x$0 -> this.method_37066((class_364)x$0), tab -> {
        lastTab = Math.max(0, this.tabNavigation.method_71284().indexOf(tab));
    }, tab -> {});
    @Nullable
    private class_8089 tabNavigation;
    @Nullable
    private MinimapWidget minimapWidget;
    private final class_8132 layout = new class_8132((class_437)this, 33, 0);
    private final int bulletPointWidth;
    private final List<QuestionWidget> questionWidgets;
    private List<Clues.Page> cluePages;
    private int currentPage;
    private boolean lastQuestionsActive;

    public SeekerSeekingScreen() {
        super(TITLE_TEXT);
        this.bulletPointWidth = class_310.method_1551().field_1772.method_1727(BULLET_POINT);
        this.questionWidgets = new ObjectArrayList();
        this.currentPage = 0;
        this.lastQuestionsActive = this.areQuestionsActive();
        this.refreshCluePages();
    }

    private List<Clues.Page> initCluePages() {
        return GameLayer.INSTANCE.getClues().getPages((arg_0, arg_1) -> ((class_327)class_310.method_1551().field_1772).method_1728(arg_0, arg_1), 116 - this.bulletPointWidth, 152, 4);
    }

    public void refreshCluePages() {
        this.cluePages = this.initCluePages();
        this.currentPage = class_3532.method_15340((int)this.currentPage, (int)0, (int)(this.cluePages.size() - 1));
    }

    protected void method_25426() {
        this.tabNavigation = class_8089.method_48623((class_8088)this.tabManager, (int)this.field_22789).method_48631(new class_8087[]{new MinimapTab(this), new CluesTab(), new QuestionsTab()}).method_48627();
        this.method_37063((class_364)this.tabNavigation);
        this.layout.method_48206(child -> {
            child.method_48591(1);
            this.method_37063((class_364)child);
        });
        if (this.tabNavigation != null) {
            lastTab = class_3532.method_15340((int)lastTab, (int)0, (int)(this.tabNavigation.method_71284().size() - 1));
            this.tabNavigation.method_48987(lastTab, false);
        }
        this.method_48640();
    }

    public void method_25393() {
        boolean questionsActive = this.areQuestionsActive();
        if (questionsActive != this.lastQuestionsActive) {
            this.lastQuestionsActive = questionsActive;
            this.questionWidgets.forEach(widget -> {
                widget.field_22763 = questionsActive;
            });
        }
        if (this.minimapWidget != null) {
            this.minimapWidget.tick();
        }
    }

    private boolean areQuestionsActive() {
        return GameLayer.INSTANCE.getActiveQuestion() == null && GameLayer.INSTANCE.getSeekerQuestionCooldown() <= 0 && GameLayer.INSTANCE.getActiveChallenges().isEmpty();
    }

    protected void method_57735(class_332 context) {
        context.method_25290(class_10799.field_56883, class_525.field_49902, 0, 0, 0.0f, 0.0f, this.field_22789, this.layout.method_48998(), 16, 16);
        this.method_57736(context, 0, this.layout.method_48998(), this.field_22789, this.field_22790);
    }

    protected void method_48640() {
        if (this.tabNavigation != null) {
            this.tabNavigation.method_48618(this.field_22789);
            this.tabNavigation.method_49613();
            int bottom = this.tabNavigation.method_48202().method_49619();
            class_8030 screenRect = new class_8030(0, bottom, this.field_22789, this.field_22790 - this.layout.method_48994() - bottom);
            this.tabManager.method_48616(screenRect);
            this.layout.method_48995(bottom);
            this.layout.method_48222();
        }
    }

    @Override
    public void method_25394(class_332 ctx, int mouseX, int mouseY, float deltaTicks) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        if (this.tabManager.method_48614() instanceof CluesTab) {
            ctx.method_25290(class_10799.field_56883, class_3872.field_17117, (this.field_22789 - 192) / 2, (this.field_22790 - 192) / 2, 0.0f, 0.0f, 192, 192, 256, 256);
            int topY = (this.field_22790 - 192) / 2 + 16;
            if (this.currentPage < this.cluePages.size() && this.currentPage >= 0) {
                Clues.Page page = this.cluePages.get(this.currentPage);
                int x = (this.field_22789 - 192) / 2 + 34;
                page.forEach(4, (text, y, startOfEntry) -> {
                    ctx.method_51430(textRenderer, text, x + this.bulletPointWidth, y + topY, -16777216, false);
                    if (startOfEntry) {
                        ctx.method_51433(textRenderer, BULLET_POINT, x, y + topY, -16777216, false);
                    }
                });
            } else {
                int y2 = 0;
                for (class_2561 text2 : NO_CLUES_TEXT) {
                    for (class_5481 orderedText : textRenderer.method_1728((class_5348)text2, 116)) {
                        int x = (this.field_22789 - textRenderer.method_30880(orderedText)) / 2;
                        ctx.method_51430(textRenderer, orderedText, x, y2 + topY, -8355712, false);
                        y2 += 9;
                    }
                    y2 += 4;
                }
            }
        } else if (this.tabManager.method_48614() instanceof QuestionsTab) {
            Question.Category[] categories = Question.Category.values();
            int y3 = this.layout.method_48998();
            for (int i = 0; i < categories.length; ++i) {
                Question.Category category = categories[i];
                int x = this.field_22789 * i / 4 + this.field_22789 / 8;
                class_5250 categoryTitle = class_2561.method_43471((String)category.getTranslationKey());
                int categoryTitleWidth = textRenderer.method_27525((class_5348)categoryTitle);
                class_2561 rewardText = category.getRewardText();
                ctx.method_51439(textRenderer, (class_2561)categoryTitle, x - categoryTitleWidth / 2, y3 + 10, -1, true);
                ctx.method_25294(x - categoryTitleWidth / 2, y3 + 19, x + categoryTitleWidth / 2, y3 + 20, category.getColor());
                ctx.method_51439(textRenderer, rewardText, x - textRenderer.method_27525((class_5348)rewardText) / 2, y3 + 22, -6250336, true);
            }
        }
        super.method_25394(ctx, mouseX, mouseY, deltaTicks);
    }

    class MinimapTab
    extends SeekingTab {
        private final MinimapWidget minimapWidget;
        private final List<class_8662> buttonWidgets = new ObjectArrayList();

        public MinimapTab(SeekerSeekingScreen this$0) {
            super(this$0, MINIMAP_TAB_TITLE_TEXT);
            this$0.minimapWidget = this.minimapWidget = this.addWidget(new MinimapWidget(0, 0, 160, MinimapWidget.ClickAction.NONE), CENTERED_POSITIONER);
            int i = 0;
            for (MinimapWidget.ClickAction clickAction : MinimapWidget.ClickAction.values()) {
                class_2960 texture = clickAction.getTexture();
                if (texture == null) continue;
                int buttonY = i * 18;
                class_5250 message = class_2561.method_43471((String)clickAction.getTranslationKey());
                class_8662 clickActionWidget = this.addWidget(class_8662.method_52723((class_2561)message, button -> this.onPress(button, clickAction), (boolean)true).method_52726(16, 16).method_52727(clickAction.getTexture(), 12, 12).method_52724(), (widget, screenRect) -> {
                    widget.method_46421(this.minimapWidget.method_46426() - 21);
                    widget.method_46419(this.minimapWidget.method_46427() + buttonY);
                });
                clickActionWidget.method_47400(class_7919.method_47407((class_2561)message));
                this.buttonWidgets.add(clickActionWidget);
                ++i;
            }
        }

        private void onPress(class_4185 widget, MinimapWidget.ClickAction clickAction) {
            this.minimapWidget.setClickAction(clickAction);
            for (class_8662 buttonWidget : this.buttonWidgets) {
                buttonWidget.field_22763 = !buttonWidget.equals(widget);
            }
        }
    }

    class CluesTab
    extends SeekingTab {
        private final class_474 prevPageWidget;
        private final class_474 nextPageWidget;

        public CluesTab() {
            super(SeekerSeekingScreen.this, CLUES_TAB_TITLE_TEXT);
            int bookTextureOffset = 96;
            this.prevPageWidget = this.addWidget(new class_474(0, 0, false, button -> this.prevPage(), true), (widget, screenRect) -> {
                widget.method_46421(screenRect.method_48254(class_8027.field_41822) - bookTextureOffset + 43);
                widget.method_46419(screenRect.method_48254(class_8027.field_41823) + bookTextureOffset - 36);
            });
            this.nextPageWidget = this.addWidget(new class_474(0, 0, true, button -> this.nextPage(), true), (widget, screenRect) -> {
                widget.method_46421(screenRect.method_48254(class_8027.field_41822) - bookTextureOffset + 116);
                widget.method_46419(screenRect.method_48254(class_8027.field_41823) + bookTextureOffset - 36);
            });
            this.updatePageTurnWidgets();
        }

        private void prevPage() {
            if (SeekerSeekingScreen.this.currentPage > 0) {
                --SeekerSeekingScreen.this.currentPage;
            }
            this.updatePageTurnWidgets();
        }

        private void nextPage() {
            if (SeekerSeekingScreen.this.currentPage < SeekerSeekingScreen.this.cluePages.size() - 1) {
                ++SeekerSeekingScreen.this.currentPage;
            }
            this.updatePageTurnWidgets();
        }

        private void updatePageTurnWidgets() {
            this.prevPageWidget.field_22764 = SeekerSeekingScreen.this.currentPage > 0;
            this.nextPageWidget.field_22764 = SeekerSeekingScreen.this.currentPage < SeekerSeekingScreen.this.cluePages.size() - 1;
        }
    }

    class QuestionsTab
    extends SeekingTab {
        public QuestionsTab() {
            super(SeekerSeekingScreen.this, QUESTIONS_TAB_TITLE_TEXT);
            SeekerSeekingScreen.this.questionWidgets.clear();
            EnumMap<Question.Category, Integer> indices = new EnumMap<Question.Category, Integer>(Question.Category.class);
            for (Question.Category category : Question.Category.values()) {
                indices.put(category, 0);
            }
            for (Question question : ModRegistries.QUESTION) {
                Question.Category category = question.getCategory();
                int index = (Integer)indices.get((Object)category);
                QuestionWidget widget = new QuestionWidget(0, 0, question, this::pressAction);
                widget.field_22763 = SeekerSeekingScreen.this.lastQuestionsActive;
                SeekerSeekingScreen.this.questionWidgets.add(widget);
                this.addWidget(widget, QuestionsTab.pos(category.ordinal(), index, 22, 40, 5));
                indices.put(category, index + 1);
            }
        }

        private void pressAction(QuestionWidget widget) {
            ClientPlayNetworking.send((class_8710)new AskQuestionC2SPayload(widget.getQuestion()));
            SeekerSeekingScreen.this.method_25419();
        }

        private static BiConsumer<class_339, class_8030> pos(int column, int index, int width, int yMargin, int xPadding) {
            return (widget, screenRect) -> {
                int sectionWidth = screenRect.comp_1196() / 4;
                int widgetsPerSection = (sectionWidth - xPadding * 2) / width;
                int rowIndex = index / widgetsPerSection;
                int columnIndex = index % widgetsPerSection;
                widget.method_46421(sectionWidth * column + xPadding + columnIndex * width);
                widget.method_46419(screenRect.method_49618() + yMargin + rowIndex * width);
            };
        }
    }

    abstract class SeekingTab
    implements class_8087 {
        private final class_2561 title;
        private final List<class_339> widgets = new ObjectArrayList();
        private final List<BiConsumer<class_339, class_8030>> positioners = new ObjectArrayList();

        public SeekingTab(SeekerSeekingScreen this$0, class_2561 title) {
            this.title = title;
        }

        public <T extends class_339> T addWidget(T widget, BiConsumer<class_339, class_8030> positioner) {
            this.widgets.add(widget);
            this.positioners.add(positioner);
            return widget;
        }

        public class_2561 method_48610() {
            return this.title;
        }

        public class_2561 method_71245() {
            return class_2561.method_43473();
        }

        public void method_48612(Consumer<class_339> consumer) {
            this.widgets.forEach(consumer);
        }

        public void method_48611(class_8030 tabArea) {
            for (int i = 0; i < this.widgets.size(); ++i) {
                this.positioners.get(i).accept(this.widgets.get(i), tabArea);
            }
        }
    }
}

