/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.hideandseek.client.screen;

import com.eightsidedsquare.hideandseek.client.layer.GameLayer;
import com.eightsidedsquare.hideandseek.common.game.question.Question;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4264;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_7999;
import net.minecraft.class_8000;
import net.minecraft.class_8030;
import net.minecraft.class_8092;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

public class QuestionWidget
extends class_4264 {
    private static final int RED_COLOR = -44462;
    private static final int TOOLTIP_WIDTH = 170;
    private static final class_2561 ALREADY_CHOSEN_TEXT = class_2561.method_43471((String)"question.already_chosen").method_54663(-44462);
    private static final class_2561 IN_PROGRESS_TEXT = class_2561.method_43471((String)"question.in_progress").method_54663(-44462);
    private static final class_2561 CHALLENGE_ACTIVE_TEXT = class_2561.method_43471((String)"question.challenge_active").method_54663(-44462);
    private static final class_2561 COOLDOWN_TEXT = class_2561.method_43471((String)"question.cooldown").method_54663(-44462);
    private final Question question;
    private final Consumer<QuestionWidget> pressAction;
    @Nullable
    private List<class_5481> tooltipLines;

    public QuestionWidget(int x, int y, Question question, Consumer<QuestionWidget> pressAction) {
        super(x, y, 19, 19, (class_2561)class_2561.method_43471((String)question.getTranslationKey()));
        this.question = question;
        this.pressAction = pressAction;
    }

    public void method_25306() {
        this.pressAction.accept(this);
    }

    protected void method_48579(class_332 ctx, int mouseX, int mouseY, float deltaTicks) {
        boolean focused;
        int timesAsked = this.getTimesAsked();
        ctx.method_52707(class_10799.field_56883, this.question.getCategory().getTexture(timesAsked, this.field_22763, this.method_25367()), this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), class_9848.method_61317((float)this.field_22765));
        ctx.method_52707(class_10799.field_56883, this.question.getTexture(), this.method_46426() + 1, this.method_46427() + 1, 16, 16, class_9848.method_61317((float)this.field_22765));
        boolean bl = focused = this.method_25370() && class_310.method_1551().method_48186().method_48183();
        if (this.method_49606() || focused) {
            class_327 textRenderer = class_310.method_1551().field_1772;
            class_8000 positioner = this.createPositioner(this.method_48202(), focused);
            ctx.method_51436(textRenderer, this.getTooltipLines(textRenderer), positioner, mouseX, mouseY, this.method_25370());
        }
    }

    private class_8000 createPositioner(class_8030 focus, boolean focused) {
        return !this.method_49606() && focused && class_310.method_1551().method_48186().method_48183() ? new class_7999(focus) : new class_8092(focus);
    }

    private int getTimesAsked() {
        return GameLayer.INSTANCE.getQuestionStates().getTimesAsked(this.question);
    }

    private List<class_5481> getTooltipLines(class_327 textRenderer) {
        if (!this.field_22763) {
            if (GameLayer.INSTANCE.getActiveQuestion() != null) {
                return textRenderer.method_1728((class_5348)IN_PROGRESS_TEXT, 170);
            }
            if (!GameLayer.INSTANCE.getActiveChallenges().isEmpty()) {
                return textRenderer.method_1728((class_5348)CHALLENGE_ACTIVE_TEXT, 170);
            }
            if (GameLayer.INSTANCE.getSeekerQuestionCooldown() > 0) {
                return textRenderer.method_1728((class_5348)COOLDOWN_TEXT, 170);
            }
        }
        if (this.tooltipLines == null) {
            this.tooltipLines = new ObjectArrayList();
            this.tooltipLines.addAll(textRenderer.method_1728((class_5348)this.method_25369(), 170));
            if (this.getTimesAsked() > 0) {
                this.tooltipLines.addAll(textRenderer.method_1728((class_5348)ALREADY_CHOSEN_TEXT, 170));
            }
        }
        return this.tooltipLines;
    }

    protected void method_47399(class_6382 builder) {
        if (this.getTimesAsked() > 0) {
            builder.method_37034(class_6381.field_33790, ALREADY_CHOSEN_TEXT);
        }
    }

    public Question getQuestion() {
        return this.question;
    }
}

