/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.hideandseek.client.screen;

import com.eightsidedsquare.hideandseek.client.layer.GameLayer;
import com.eightsidedsquare.hideandseek.client.screen.GameScreen;
import com.eightsidedsquare.hideandseek.client.screen.PowerupWidget;
import com.eightsidedsquare.hideandseek.common.game.powerup.Powerup;
import com.eightsidedsquare.hideandseek.common.game.powerup.PowerupHand;
import com.eightsidedsquare.hideandseek.common.game.powerup.PowerupReward;
import com.eightsidedsquare.hideandseek.common.network.PickPowerupsC2SPayload;
import com.eightsidedsquare.hideandseek.core.ModInit;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5348;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;

public class PowerupRewardScreen
extends GameScreen {
    private static final class_2960 HIDER_HOTBAR = ModInit.id("hider_hotbar");
    private static final class_2561 TITLE_TEXT = class_2561.method_43471((String)"hideandseek.powerup_reward.title");
    private static final class_2561 PICK_POWERUP_TEXT = class_2561.method_43471((String)"hideandseek.powerup_reward.pick_powerup");
    private static final class_2561 CONFIRM_TEXT = class_2561.method_43471((String)"hideandseek.powerup_reward.confirm");
    private PowerupReward reward;
    private class_2561 rewardText;
    @Nullable
    private class_2561 discardText;
    private int discardRequirement;
    private class_4185 confirmButton;
    private int age;
    private final List<PowerupWidget> handPowerupWidgets = new ObjectArrayList();
    private final List<PowerupWidget> rewardPowerupWidgets = new ObjectArrayList();

    public PowerupRewardScreen() {
        super(TITLE_TEXT);
    }

    protected void method_25426() {
        PowerupHand powerups = GameLayer.INSTANCE.getHiderPowerups();
        if (powerups.getRewardQueue().isEmpty()) {
            this.method_25419();
            return;
        }
        this.reward = powerups.getRewardQueue().getFirst();
        int drawCount = this.reward.powerups().size();
        this.rewardText = class_2561.method_43469((String)(this.reward.pickCount() == 1 ? "hideandseek.powerup_reward.reward_one" : "hideandseek.powerup_reward.reward"), (Object[])new Object[]{this.reward.pickCount()});
        this.discardRequirement = class_3532.method_15340((int)(powerups.getHand().size() + this.reward.pickCount() - 5), (int)0, (int)5);
        this.discardText = switch (this.discardRequirement) {
            case 0 -> null;
            case 1 -> class_2561.method_43471((String)"hideandseek.powerup_reward.discard_one");
            default -> class_2561.method_43469((String)"hideandseek.powerup_reward.discard", (Object[])new Object[]{this.discardRequirement});
        };
        this.confirmButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)CONFIRM_TEXT, button -> this.confirm()).method_46434(this.field_22789 / 2 - 30, this.field_22790 - 60, 60, 20).method_46431());
        this.confirmButton.field_22763 = false;
        this.handPowerupWidgets.clear();
        this.rewardPowerupWidgets.clear();
        int hotbarLeft = (this.field_22789 - 196) / 2;
        for (int i = 0; i < powerups.getHand().size(); ++i) {
            this.handPowerupWidgets.add((PowerupWidget)this.method_37063((class_364)new PowerupWidget(hotbarLeft + 6 + i * 38, this.field_22790 - 104, 32, powerups.getHand().get(i), this.discardRequirement == 0 ? PowerupWidget.ClickAction.NONE : PowerupWidget.ClickAction.DISCARD, this::updateConfirmButton)));
        }
        int rewardLeft = (this.field_22789 - drawCount * 32 - Math.max(0, drawCount - 1) * 5) / 2;
        for (int i = 0; i < drawCount; ++i) {
            this.rewardPowerupWidgets.add((PowerupWidget)this.method_37063((class_364)new PowerupWidget(rewardLeft + i * 37, 60, 32, this.reward.powerups().get(i), PowerupWidget.ClickAction.PICK, this::updateConfirmButton)));
        }
    }

    private void updateConfirmButton() {
        int discards = 0;
        for (PowerupWidget widget : this.handPowerupWidgets) {
            if (!widget.selected) continue;
            ++discards;
        }
        if (discards != this.discardRequirement) {
            this.confirmButton.field_22763 = false;
            return;
        }
        int picked = 0;
        for (PowerupWidget widget : this.rewardPowerupWidgets) {
            if (!widget.selected) continue;
            ++picked;
        }
        this.confirmButton.field_22763 = picked == this.reward.pickCount();
    }

    private void confirm() {
        ObjectArrayList picked = new ObjectArrayList();
        ObjectArrayList discarded = new ObjectArrayList();
        for (PowerupWidget widget : this.rewardPowerupWidgets) {
            if (!widget.selected) continue;
            picked.add(widget.powerup);
        }
        for (PowerupWidget widget : this.handPowerupWidgets) {
            if (!widget.selected) continue;
            discarded.add(widget.powerup);
        }
        ClientPlayNetworking.send((class_8710)new PickPowerupsC2SPayload((List<Powerup>)picked, (List<Powerup>)discarded));
        this.method_25419();
    }

    @Override
    public void method_25394(class_332 ctx, int mouseX, int mouseY, float deltaTicks) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        int halfWidth = ctx.method_51421() / 2;
        ctx.method_52706(class_10799.field_56883, HIDER_HOTBAR, halfWidth - 98, ctx.method_51443() - 110, 196, 44);
        ctx.method_51448().pushMatrix();
        ctx.method_51448().translate((float)halfWidth, 10.0f);
        if (this.discardText != null) {
            ctx.method_51439(textRenderer, this.discardText, textRenderer.method_27525((class_5348)this.discardText) / -2, 30, -1, true);
        }
        ctx.method_51439(textRenderer, PICK_POWERUP_TEXT, textRenderer.method_27525((class_5348)PICK_POWERUP_TEXT) / -2, 20, -1, true);
        ctx.method_51448().scale(2.0f);
        ctx.method_51439(textRenderer, this.rewardText, textRenderer.method_27525((class_5348)this.rewardText) / -2, 0, -1, true);
        ctx.method_51448().popMatrix();
        super.method_25394(ctx, mouseX, mouseY, deltaTicks);
    }

    public void method_25393() {
        ++this.age;
    }
}

