/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.hideandseek.client.screen;

import com.eightsidedsquare.hideandseek.client.layer.GameLayer;
import com.eightsidedsquare.hideandseek.client.texture.MinimapTextureManager;
import com.eightsidedsquare.hideandseek.client.util.ClientGamePlayer;
import com.eightsidedsquare.hideandseek.common.game.state.GameDimensions;
import com.eightsidedsquare.hideandseek.common.network.MarkWorldC2SPayload;
import com.eightsidedsquare.hideandseek.common.network.TeleportC2SPayload;
import com.eightsidedsquare.hideandseek.core.ModInit;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.datafixers.util.Either;
import java.util.UUID;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1058;
import net.minecraft.class_1060;
import net.minecraft.class_10799;
import net.minecraft.class_11200;
import net.minecraft.class_21;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_6382;
import net.minecraft.class_746;
import net.minecraft.class_7532;
import net.minecraft.class_7919;
import net.minecraft.class_8710;
import net.minecraft.class_9428;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public class MinimapWidget
extends class_339 {
    private static final int MARK_COLOR = -855638017;
    private static final class_2960 MAP_TEXTURE = class_2960.method_60656((String)"container/cartography_table/map");
    private static final class_2561 TELEPORT_TEXT = class_2561.method_43471((String)"hideandseek.minimap.teleport");
    private static final class_2561 ADD_WAYPOINT_TEXT = class_2561.method_43471((String)"hideandseek.minimap.add_waypoint");
    private static final class_2561 CHALLENGE_ACTIVE_TEXT = class_2561.method_43471((String)"hideandseek.minimap.challenge_active").method_54663(-44462);
    private static final class_2561 COOLDOWN_TEXT = class_2561.method_43471((String)"hideandseek.minimap.cooldown").method_54663(-44462);
    private static final class_2561 SELECT_START_TEXT = class_2561.method_43471((String)"hideandseek.minimap.select_start");
    private static final class_2561 SELECT_END_TEXT = class_2561.method_43471((String)"hideandseek.minimap.select_end");
    private ClickAction clickAction;
    @Nullable
    private Vector2i selection;

    public MinimapWidget(int x, int y, int size, ClickAction clickAction) {
        super(x, y, size, size, (class_2561)class_2561.method_43473());
        this.setClickAction(clickAction);
    }

    protected void method_48579(class_332 ctx, int mouseX, int mouseY, float deltaTicks) {
        int margin = this.field_22758 / 20;
        ctx.method_52706(class_10799.field_56883, MAP_TEXTURE, this.method_46426() - margin, this.method_46427() - margin, this.method_25368() + margin * 2, this.method_25368() + margin * 2);
        ctx.method_25294(this.method_46426(), this.method_46427(), this.method_55442(), this.method_55443(), -8754090);
        GameDimensions dimensions = GameLayer.INSTANCE.getDimensions();
        if (dimensions == null) {
            return;
        }
        class_1060 textureManager = class_310.method_1551().method_1531();
        GpuTextureView terrainTextureView = textureManager.method_4619(MinimapTextureManager.TERRAIN_TEXTURE).method_71659();
        ctx.method_70847(class_10799.field_56883, terrainTextureView, this.method_46426(), this.method_46427(), this.method_55442(), this.method_55443(), 0.0f, 1.0f, 0.0f, 1.0f, -1);
        GpuTextureView markingTextureView = textureManager.method_4619(MinimapTextureManager.MARKING_TEXTURE).method_71659();
        ctx.method_70847(class_10799.field_56883, markingTextureView, this.method_46426(), this.method_46427(), this.method_55442(), this.method_55443(), 0.0f, 1.0f, 0.0f, 1.0f, -1);
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        for (class_11200 trackedWaypoint : player.field_3944.method_70936().field_59989.values()) {
            if (!(trackedWaypoint instanceof class_11200.class_11206)) continue;
            class_11200.class_11206 positionalWaypoint = (class_11200.class_11206)trackedWaypoint;
            class_2382 pos = positionalWaypoint.field_59784;
            if (!dimensions.containsBlock(pos.method_10263(), pos.method_10260())) continue;
            Either source = positionalWaypoint.method_70763();
            int x = (int)class_3532.method_37959((float)pos.method_10263(), (float)dimensions.x1(), (float)dimensions.x2(), (float)this.method_46426(), (float)this.method_55442());
            int y = (int)class_3532.method_37959((float)pos.method_10260(), (float)dimensions.z1(), (float)dimensions.z2(), (float)this.method_46427(), (float)this.method_55443());
            int color = this.getColor(mouseX, mouseY, x, y);
            source.ifLeft(uuid -> {
                ClientGamePlayer gamePlayer = (ClientGamePlayer)GameLayer.INSTANCE.getGamePlayer((UUID)uuid);
                if (gamePlayer != null) {
                    class_7532.method_44445((class_332)ctx, (class_2960)gamePlayer.getSkinTexture(), (int)(x - 4), (int)(y - 4), (int)8, (boolean)true, (boolean)false, (int)color);
                }
            });
        }
        if (!dimensions.containsBlock(player.method_31477(), player.method_31479())) {
            return;
        }
        class_1058 sprite = this.getPlayerMapSprite();
        if (sprite == null) {
            return;
        }
        ctx.method_51448().pushMatrix();
        float x = (float)class_3532.method_33722((double)player.method_23317(), (double)dimensions.x1(), (double)dimensions.x2(), (double)this.method_46426(), (double)this.method_55442());
        float y = (float)class_3532.method_33722((double)player.method_23321(), (double)dimensions.z1(), (double)dimensions.z2(), (double)this.method_46427(), (double)this.method_55443());
        ctx.method_51448().translate(x, y);
        ctx.method_51448().rotate(player.method_5791() * ((float)Math.PI / 180));
        ctx.method_51448().translate(-4.0f, -4.0f);
        ctx.method_70847(class_10799.field_56883, textureManager.method_4619(sprite.method_45852()).method_71659(), 0, 0, 8, 8, sprite.method_4594(), sprite.method_4577(), sprite.method_4575(), sprite.method_4593(), this.getColor(mouseX, mouseY, (int)x, (int)y));
        ctx.method_51448().popMatrix();
        if (this.selection != null) {
            int selectionX = this.convertToScreenX(this.selection.x);
            int selectionY = this.convertToScreenY(this.selection.y);
            int x1 = Math.max(this.method_46426(), Math.min(selectionX, mouseX));
            int y1 = Math.max(this.method_46427(), Math.min(selectionY, mouseY));
            int x2 = Math.min(this.method_55442(), Math.max(selectionX, mouseX));
            int y2 = Math.min(this.method_55443(), Math.max(selectionY, mouseY));
            ctx.method_25294(x1, y1, x2, y2, -855638017);
        }
    }

    @Nullable
    private class_1058 getPlayerMapSprite() {
        return class_310.method_1551().method_58476().method_18667(((class_9428)class_21.field_91.comp_349()).comp_2514());
    }

    private int getColor(int mouseX, int mouseY, int x, int y) {
        int dX = mouseX - x;
        int dY = mouseY - y;
        return class_9848.method_71346((float)class_3532.method_15363((float)(class_3532.method_15355((float)(dX * dX + dY * dY)) * 0.025f), (float)0.2f, (float)1.0f), (int)-1);
    }

    public void tick() {
        this.updateTooltip();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.field_22763 && this.field_22764 && button == 1 && this.method_25405(mouseX, mouseY) && this.selection != null && (this.clickAction == ClickAction.DRAW || this.clickAction == ClickAction.ERASE)) {
            this.selection = null;
            this.method_25354(class_310.method_1551().method_1483());
            this.updateTooltip();
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25348(double mouseX, double mouseY) {
        switch (this.clickAction.ordinal()) {
            case 1: {
                this.sendTeleportRequest(mouseX, mouseY);
                break;
            }
            case 2: 
            case 3: {
                this.mark(mouseX, mouseY);
            }
        }
    }

    private void mark(double mouseX, double mouseY) {
        Vector2i pos = this.convertToWorldPos(mouseX, mouseY);
        if (pos == null) {
            return;
        }
        if (this.selection == null) {
            this.selection = pos;
            this.updateTooltip();
        } else {
            int x1 = Math.min(this.selection.x, pos.x);
            int z1 = Math.min(this.selection.y, pos.y);
            int x2 = Math.max(this.selection.x, pos.x);
            int z2 = Math.max(this.selection.y, pos.y);
            ClientPlayNetworking.send((class_8710)new MarkWorldC2SPayload(x1, z1, x2, z2, this.clickAction == ClickAction.DRAW));
            this.selection = null;
            this.updateTooltip();
        }
    }

    public void setClickAction(ClickAction clickAction) {
        this.clickAction = clickAction;
        this.updateTooltip();
        this.field_22763 = this.clickAction != ClickAction.NONE;
        this.selection = null;
    }

    private void updateTooltip() {
        switch (this.clickAction.ordinal()) {
            case 1: {
                this.method_47400(class_7919.method_47407((class_2561)this.getTpTooltip()));
                break;
            }
            case 2: 
            case 3: {
                this.method_47400(class_7919.method_47407((class_2561)(this.selection == null ? SELECT_START_TEXT : SELECT_END_TEXT)));
                break;
            }
            default: {
                this.method_47400(null);
            }
        }
    }

    private class_2561 getTpTooltip() {
        if (GameLayer.INSTANCE.isSeeker()) {
            if (!GameLayer.INSTANCE.getActiveChallenges().isEmpty()) {
                return CHALLENGE_ACTIVE_TEXT;
            }
            if (GameLayer.INSTANCE.getSeekerTpCooldown() > 0) {
                return COOLDOWN_TEXT;
            }
        }
        return TELEPORT_TEXT;
    }

    public ClickAction getClickAction() {
        return this.clickAction;
    }

    private void sendTeleportRequest(double mouseX, double mouseY) {
        Vector2i pos = this.convertToWorldPos(mouseX, mouseY);
        if (pos == null) {
            return;
        }
        if (GameLayer.INSTANCE.isSeeker() && GameLayer.INSTANCE.canSeekersTeleport()) {
            ClientPlayNetworking.send((class_8710)new TeleportC2SPayload(false, pos.x, pos.y));
            class_310.method_1551().method_1507(null);
        } else if (GameLayer.INSTANCE.isHider()) {
            ClientPlayNetworking.send((class_8710)new TeleportC2SPayload(true, pos.x, pos.y));
            class_310.method_1551().method_1507(null);
        }
    }

    @Nullable
    private Vector2i convertToWorldPos(double mouseX, double mouseY) {
        GameDimensions dimensions = GameLayer.INSTANCE.getDimensions();
        if (dimensions == null) {
            return null;
        }
        int x = (int)class_3532.method_33722((double)mouseX, (double)this.method_46426(), (double)this.method_55442(), (double)dimensions.x1(), (double)dimensions.x2());
        int z = (int)class_3532.method_33722((double)mouseY, (double)this.method_46427(), (double)this.method_55443(), (double)dimensions.z1(), (double)dimensions.z2());
        return new Vector2i(x, z);
    }

    private int convertToScreenX(int x) {
        GameDimensions dimensions = GameLayer.INSTANCE.getDimensions();
        if (dimensions == null) {
            return 0;
        }
        return (int)class_3532.method_37959((float)x, (float)dimensions.x1(), (float)dimensions.x2(), (float)this.method_46426(), (float)this.method_55442());
    }

    private int convertToScreenY(int y) {
        GameDimensions dimensions = GameLayer.INSTANCE.getDimensions();
        if (dimensions == null) {
            return 0;
        }
        return (int)class_3532.method_37959((float)y, (float)dimensions.z1(), (float)dimensions.z2(), (float)this.method_46427(), (float)this.method_55443());
    }

    protected void method_47399(class_6382 builder) {
    }

    public static enum ClickAction {
        NONE("none", false),
        TELEPORT("teleport", true),
        DRAW("draw", true),
        ERASE("erase", true);

        @Nullable
        private final class_2960 texture;
        private final String translationKey;

        private ClickAction(String name, boolean hasTexture) {
            this.texture = hasTexture ? ModInit.id(name) : null;
            this.translationKey = "hideandseek.minimap.click_action." + name;
        }

        @Nullable
        public class_2960 getTexture() {
            return this.texture;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }
    }
}

