/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.hideandseek.client.layer;

import com.eightsidedsquare.hideandseek.client.layer.GameLayer;
import com.eightsidedsquare.hideandseek.client.layer.GameSubLayer;
import com.eightsidedsquare.hideandseek.client.util.ClientGamePlayer;
import com.eightsidedsquare.hideandseek.core.ModInit;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_10799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3544;
import net.minecraft.class_638;
import net.minecraft.class_7532;
import net.minecraft.class_9779;
import org.jetbrains.annotations.NotNull;

public class LeaderboardSubLayer
extends GameSubLayer {
    public static LeaderboardSubLayer instance;
    private static final class_2960 PLAQUE;
    private static final class_2960 PLAQUE_FIRST;
    private static final class_2960 PLAQUE_SECOND;
    private static final class_2960 PLAQUE_THIRD;
    private static final class_2960 PLAQUE_SMALL;
    private final List<Plaque> plaques = new ObjectArrayList();

    public LeaderboardSubLayer(GameLayer gameLayer) {
        super(gameLayer);
        instance = this;
    }

    private void sort() {
        this.plaques.sort(Plaque::compareTo);
        List<Plaque> plaqueList = this.plaques;
        int i = 0;
        while (i < plaqueList.size()) {
            Plaque plaque = plaqueList.get(i);
            plaque.rank = i++;
        }
    }

    @Override
    public void onHiderTimesUpdated() {
        this.sort();
    }

    @Override
    public void onPlayerAdded(ClientGamePlayer gamePlayer) {
        this.plaques.add(new Plaque(gamePlayer));
        this.sort();
    }

    @Override
    public void onPlayersClear() {
        this.plaques.clear();
    }

    @Override
    public void onClear() {
        this.plaques.clear();
    }

    @Override
    public void tick(class_638 world) {
        this.sort();
    }

    @Override
    public void render(class_332 ctx, class_9779 tickCounter, class_638 world) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        float tickRate = world.method_54719().method_54748();
        int y = 2;
        int x = ctx.method_51421() - 56;
        for (Plaque plaque : this.plaques) {
            ClientGamePlayer gamePlayer = plaque.player;
            this.drawPlaqueBackground(ctx, plaque, x, y);
            if (plaque.shouldRenderSmall()) {
                class_7532.method_44445((class_332)ctx, (class_2960)gamePlayer.getSkinTexture(), (int)(x + 43), (int)(y + 2), (int)8, (boolean)true, (boolean)false, (int)-1);
            } else {
                class_7532.method_44445((class_332)ctx, (class_2960)gamePlayer.getSkinTexture(), (int)(x + 2), (int)(y + 2), (int)8, (boolean)true, (boolean)false, (int)-1);
                String time = class_3544.method_15439((int)Math.max(0, gamePlayer.getHidingTime()), (float)tickRate);
                ctx.method_51433(textRenderer, time, ctx.method_51421() - 4 - textRenderer.method_1727(time), y + 2, -1, true);
            }
            y += 15;
        }
    }

    private void drawPlaqueBackground(class_332 ctx, Plaque plaque, int x, int y) {
        if (plaque.shouldRenderSmall()) {
            ctx.method_52706(class_10799.field_56883, PLAQUE_SMALL, x + 41, y, 13, 13);
            return;
        }
        class_2960 texture = switch (plaque.rank) {
            case 0 -> PLAQUE_FIRST;
            case 1 -> PLAQUE_SECOND;
            case 2 -> PLAQUE_THIRD;
            default -> PLAQUE;
        };
        ctx.method_52706(class_10799.field_56883, texture, x, y, 54, 13);
    }

    static {
        PLAQUE = ModInit.id("plaque");
        PLAQUE_FIRST = ModInit.id("plaque_first");
        PLAQUE_SECOND = ModInit.id("plaque_second");
        PLAQUE_THIRD = ModInit.id("plaque_third");
        PLAQUE_SMALL = ModInit.id("plaque_small");
    }

    public static class Plaque
    implements Comparable<Plaque> {
        private final ClientGamePlayer player;
        private int rank;

        public Plaque(ClientGamePlayer player) {
            this.player = player;
        }

        public boolean shouldRenderSmall() {
            return this.player.getHidingTime() < 0;
        }

        @Override
        public int compareTo(@NotNull Plaque plaque) {
            return this.player.compareTo(plaque.player);
        }
    }
}

