/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.hideandseek.client.layer;

import com.eightsidedsquare.hideandseek.client.gui.PlayerHeadGuiElementRenderState;
import com.eightsidedsquare.hideandseek.client.layer.GameLayer;
import com.eightsidedsquare.hideandseek.client.layer.GameSubLayer;
import com.eightsidedsquare.hideandseek.client.util.ClientGamePlayer;
import com.eightsidedsquare.hideandseek.core.ModSounds;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_11256;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5348;
import net.minecraft.class_5602;
import net.minecraft.class_607;
import net.minecraft.class_638;
import net.minecraft.class_9779;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

public class HiderAnnouncementSubLayer
extends GameSubLayer {
    private static final class_2561 HIDER_TEXT = class_2561.method_43471((String)"hideandseek.hider_announcement.hider");
    private static final class_2561 SEEKERS_TEXT = class_2561.method_43471((String)"hideandseek.hider_announcement.seekers");
    private static final class_2561 HIDING_BEGINS_TEXT = class_2561.method_43471((String)"hideandseek.hider_announcement.countdown.0");
    private static final class_2561 NOW_TEXT = class_2561.method_43471((String)"hideandseek.hider_announcement.countdown.1");
    private static final int MAX_ANIMATION_TICKS = 100;
    @Nullable
    private class_607 model;
    private int animationTicks;
    private boolean animating;
    @Nullable
    private ClientGamePlayer hider;
    private final List<ClientGamePlayer> seekers = new ObjectArrayList();
    @Nullable
    private DelayedAnnouncement delayedAnnouncement;

    public HiderAnnouncementSubLayer(GameLayer gameLayer) {
        super(gameLayer);
    }

    private void reset() {
        this.animationTicks = 0;
        this.animating = false;
        this.hider = null;
        this.seekers.clear();
        this.delayedAnnouncement = null;
    }

    @Override
    public void onClear() {
        this.reset();
    }

    @Override
    public void tick(class_638 world) {
        if (this.delayedAnnouncement != null && --this.delayedAnnouncement.delay <= 0) {
            this.onHiderAnnouncement(this.delayedAnnouncement.hider, this.delayedAnnouncement.seekers, 0);
        }
        if (this.animating && ++this.animationTicks >= 100) {
            this.reset();
        }
    }

    @Override
    public void onHiderAnnouncement(ClientGamePlayer hider, List<ClientGamePlayer> seekers, int delay) {
        if (delay > 0) {
            this.delayedAnnouncement = new DelayedAnnouncement(hider, seekers, delay);
            return;
        }
        this.delayedAnnouncement = null;
        this.hider = hider;
        this.seekers.clear();
        this.animationTicks = 0;
        this.seekers.addAll(seekers);
        this.animating = true;
        this.gameLayer.playSound(ModSounds.ANNOUNCE_HIDER, 1.0f, 2.0f);
    }

    @Override
    public void onReload() {
        this.model = new class_607(class_310.method_1551().method_31974().method_32072(class_5602.field_27578));
    }

    @Override
    public void render(class_332 ctx, class_9779 tickCounter, class_638 world) {
        if (!this.animating || this.hider == null || this.seekers.isEmpty() || this.model == null) {
            return;
        }
        float time = (float)this.animationTicks + tickCounter.method_60637(true);
        float pitch = class_3532.method_15362((float)time) * 10.0f;
        float yaw = class_3532.method_15374((float)time) * 10.0f;
        class_327 textRenderer = class_310.method_1551().field_1772;
        int halfWidth = ctx.method_51421() / 2;
        int halfHeight = ctx.method_51443() / 2;
        ctx.method_51448().pushMatrix();
        ctx.method_51448().translate((float)halfWidth, (float)(halfHeight - 30));
        ctx.field_59826.method_70922((class_11256)new PlayerHeadGuiElementRenderState(this.model, this.hider.getSkinTexture(), pitch, yaw, new Matrix3x2f((Matrix3x2fc)ctx.method_51448()), -30, -60, 30, 0, 1.0f, ctx.field_44659.method_70863()));
        if (this.animationTicks >= 25) {
            int seekerHeadsX = this.seekers.size() * -15;
            for (int i = 0; i < this.seekers.size(); ++i) {
                int x = seekerHeadsX + i * 30;
                ctx.field_59826.method_70922((class_11256)new PlayerHeadGuiElementRenderState(this.model, this.seekers.get(i).getSkinTexture(), pitch, yaw, new Matrix3x2f((Matrix3x2fc)ctx.method_51448()), x, 15, x + 30, 45, 1.0f, ctx.field_44659.method_70863()));
            }
        }
        ctx.method_51448().pushMatrix();
        ctx.method_51448().scale(3.0f);
        ctx.method_51439(textRenderer, HIDER_TEXT, textRenderer.method_27525((class_5348)HIDER_TEXT) / -2, -26, -1, true);
        ctx.method_51448().popMatrix();
        if (this.animationTicks >= 25) {
            ctx.method_51448().pushMatrix();
            ctx.method_51448().scale(2.0f);
            ctx.method_51439(textRenderer, SEEKERS_TEXT, textRenderer.method_27525((class_5348)SEEKERS_TEXT) / -2, 0, -1, true);
            ctx.method_51448().popMatrix();
        }
        if (this.animationTicks >= 50) {
            ctx.method_51448().pushMatrix();
            ctx.method_51448().scale(3.0f);
            ctx.method_51439(textRenderer, HIDING_BEGINS_TEXT, textRenderer.method_27525((class_5348)HIDING_BEGINS_TEXT) / -2, 15, -1, true);
            ctx.method_51448().popMatrix();
        }
        if (this.animationTicks >= 72) {
            ctx.method_51448().pushMatrix();
            ctx.method_51448().scale(4.0f);
            ctx.method_51439(textRenderer, NOW_TEXT, textRenderer.method_27525((class_5348)NOW_TEXT) / -2, 20, -1, true);
            ctx.method_51448().popMatrix();
        }
        ctx.method_51448().popMatrix();
    }

    static class DelayedAnnouncement {
        final ClientGamePlayer hider;
        final List<ClientGamePlayer> seekers;
        int delay;

        DelayedAnnouncement(ClientGamePlayer hider, List<ClientGamePlayer> seekers, int delay) {
            this.hider = hider;
            this.seekers = seekers;
            this.delay = delay;
        }
    }
}

