/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.hideandseek.client.layer;

import com.eightsidedsquare.hideandseek.client.layer.ActiveQuestionSubLayer;
import com.eightsidedsquare.hideandseek.client.layer.AnnouncementSubLayer;
import com.eightsidedsquare.hideandseek.client.layer.ChallengeSubLayer;
import com.eightsidedsquare.hideandseek.client.layer.EndResultsSubLayer;
import com.eightsidedsquare.hideandseek.client.layer.GameSubLayer;
import com.eightsidedsquare.hideandseek.client.layer.HiderAnnouncementSubLayer;
import com.eightsidedsquare.hideandseek.client.layer.HidingSpotRequirementsSubLayer;
import com.eightsidedsquare.hideandseek.client.layer.LeaderboardSubLayer;
import com.eightsidedsquare.hideandseek.client.screen.PowerupRewardScreen;
import com.eightsidedsquare.hideandseek.client.util.ClientGamePlayer;
import com.eightsidedsquare.hideandseek.common.game.challenge.Challenge;
import com.eightsidedsquare.hideandseek.common.game.player.GamePlayerManagerImpl;
import com.eightsidedsquare.hideandseek.common.game.player.GamePlayerManagerWrapper;
import com.eightsidedsquare.hideandseek.common.game.powerup.Powerup;
import com.eightsidedsquare.hideandseek.common.game.powerup.PowerupHand;
import com.eightsidedsquare.hideandseek.common.game.powerup.PowerupReward;
import com.eightsidedsquare.hideandseek.common.game.question.ActiveQuestion;
import com.eightsidedsquare.hideandseek.common.game.question.Clues;
import com.eightsidedsquare.hideandseek.common.game.question.QuestionStates;
import com.eightsidedsquare.hideandseek.common.game.state.GameState;
import com.eightsidedsquare.hideandseek.common.game.state.GameStateImpl;
import com.eightsidedsquare.hideandseek.common.game.state.GameStateWrapper;
import com.eightsidedsquare.hideandseek.common.network.GamePlayerListS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.HidingSpotRequirementsS2CPayload;
import com.eightsidedsquare.hideandseek.core.ModInit;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElement;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1068;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_437;
import net.minecraft.class_634;
import net.minecraft.class_635;
import net.minecraft.class_638;
import net.minecraft.class_640;
import net.minecraft.class_6880;
import net.minecraft.class_742;
import net.minecraft.class_746;
import net.minecraft.class_9779;
import org.jetbrains.annotations.Nullable;

public class GameLayer
implements GamePlayerManagerWrapper<ClientGamePlayer>,
GameStateWrapper,
HudElement,
ClientLoginConnectionEvents.Init,
ClientLoginConnectionEvents.Disconnect,
ClientTickEvents.EndWorldTick,
SimpleSynchronousResourceReloadListener {
    public static final GameLayer INSTANCE = new GameLayer();
    private static final class_2960 ID = ModInit.id("game");
    private final GameSubLayer[] subLayers;
    private final GamePlayerManagerImpl<ClientGamePlayer> playerManager = new GamePlayerManagerImpl();
    private final List<class_6880<Challenge>> activeChallenges = new ArrayList<class_6880<Challenge>>();
    private final Clues clues = new Clues();
    private final QuestionStates questionStates = new QuestionStates();
    private PowerupHand hiderPowerups = new PowerupHand();
    @Nullable
    private ActiveQuestion activeQuestion;
    private GameState gameState = new GameStateImpl();
    private int seekerTpCooldown;
    private int seekerQuestionCooldown;
    private boolean acceptableHidingSpot;
    private boolean hider;
    private boolean seeker;
    private int rewardScreenDelay = 0;

    private GameLayer() {
        this.subLayers = new GameSubLayer[]{new LeaderboardSubLayer(this), new HiderAnnouncementSubLayer(this), new ChallengeSubLayer(this), new HidingSpotRequirementsSubLayer(this), new ActiveQuestionSubLayer(this), new AnnouncementSubLayer(this), new EndResultsSubLayer(this)};
    }

    public Clues getClues() {
        return this.clues;
    }

    public QuestionStates getQuestionStates() {
        return this.questionStates;
    }

    public void addClues(List<class_2561> clues) {
        this.clues.addClues(clues);
        this.forEachSublayer(subLayer -> subLayer.onCluesAdded(clues));
    }

    public PowerupHand getHiderPowerups() {
        return this.hiderPowerups;
    }

    public void setHiderPowerups(PowerupHand hiderPowerups) {
        this.hiderPowerups = hiderPowerups;
    }

    @Nullable
    public ActiveQuestion getActiveQuestion() {
        return this.activeQuestion;
    }

    public void setActiveQuestion(@Nullable ActiveQuestion activeQuestion) {
        this.activeQuestion = activeQuestion;
    }

    public void setActiveQuestion(@Nullable ActiveQuestion activeQuestion, @Nullable UUID sender, boolean forceClear) {
        this.activeQuestion = activeQuestion;
        this.forEachSublayer(subLayer -> subLayer.onActiveQuestionSet(activeQuestion, sender, forceClear));
    }

    public boolean canSeekersTeleport() {
        return this.getSeekerTpCooldown() <= 0 && this.getActiveChallenges().isEmpty();
    }

    public int getSeekerTpCooldown() {
        return this.seekerTpCooldown;
    }

    public void setSeekerTpCooldown(int seekerTpCooldown) {
        this.seekerTpCooldown = seekerTpCooldown;
    }

    public int getSeekerQuestionCooldown() {
        return this.seekerQuestionCooldown;
    }

    public void setSeekerQuestionCooldown(int seekerQuestionCooldown) {
        this.seekerQuestionCooldown = seekerQuestionCooldown;
    }

    @Override
    public GamePlayerManagerImpl<ClientGamePlayer> getPlayerManager() {
        return this.playerManager;
    }

    @Override
    public GameState getGameState() {
        return this.gameState;
    }

    public void setGameState(GameState gameState) {
        this.gameState = gameState;
        this.forEachSublayer(subLayer -> subLayer.onGameStateSet(this.gameState));
    }

    public void registerEvents() {
        HudElementRegistry.addLast((class_2960)ID, (HudElement)INSTANCE);
        ClientLoginConnectionEvents.INIT.register((Object)this);
        ClientLoginConnectionEvents.DISCONNECT.register((Object)this);
        ClientTickEvents.END_WORLD_TICK.register((Object)this);
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)this);
    }

    public boolean isHider(class_1657 player) {
        ClientGamePlayer hider = (ClientGamePlayer)this.playerManager.hider;
        return hider != null && hider.getUuid().equals(player.method_5667());
    }

    public boolean isAcceptableHidingSpot() {
        return this.acceptableHidingSpot;
    }

    public boolean isHider() {
        return this.hider;
    }

    public boolean isSeeker() {
        return this.seeker;
    }

    public boolean hasPlayer(@Nullable class_1657 player) {
        return player != null && this.playerManager.getGamePlayer(player.method_5667()) != null;
    }

    @Nullable
    public class_742 getHider(class_638 world) {
        return this.playerManager.hider == null ? null : (class_742)((ClientGamePlayer)this.playerManager.hider).getPlayer(world);
    }

    @Override
    public void addPlayer(ClientGamePlayer gamePlayer) {
        GamePlayerManagerWrapper.super.addPlayer(gamePlayer);
        this.forEachSublayer(subLayer -> subLayer.onPlayerAdded(gamePlayer));
    }

    public int getRewardScreenDelay() {
        return this.rewardScreenDelay;
    }

    public void clear() {
        this.clearPlayers();
        this.gameState = new GameStateImpl();
        this.clues.clear();
        this.questionStates.clear();
        this.activeQuestion = null;
        this.hiderPowerups.clear();
        this.activeChallenges.clear();
        this.seekerTpCooldown = 0;
        this.seekerQuestionCooldown = 0;
        this.acceptableHidingSpot = false;
        this.hider = false;
        this.seeker = false;
        this.rewardScreenDelay = 0;
        this.forEachSublayer(GameSubLayer::onClear);
    }

    @Override
    public void clearPlayers() {
        GamePlayerManagerWrapper.super.clearPlayers();
        this.forEachSublayer(GameSubLayer::onPlayersClear);
    }

    public void setPlayers(class_634 networkHandler, List<GamePlayerListS2CPayload.Entry> entries) {
        this.clearPlayers();
        for (GamePlayerListS2CPayload.Entry entry : entries) {
            UUID uuid = entry.uuid();
            class_640 playerListEntry = networkHandler.method_2871(uuid);
            Supplier texturesSupplier = playerListEntry == null ? class_1068::method_62620 : playerListEntry.field_45607;
            this.addPlayer(new ClientGamePlayer(uuid, entry.hidingTime(), texturesSupplier));
        }
    }

    @Override
    public void setHidingTime(UUID uuid, int hidingTime) {
        GamePlayerManagerWrapper.super.setHidingTime(uuid, hidingTime);
        this.forEachSublayer(GameSubLayer::onHiderTimesUpdated);
    }

    @Override
    public void setHidingTimes(Object2IntMap<UUID> times) {
        GamePlayerManagerWrapper.super.setHidingTimes(times);
        this.forEachSublayer(GameSubLayer::onHiderTimesUpdated);
    }

    public void addChallenge(class_6880<Challenge> challenge) {
        if (!this.activeChallenges.contains(challenge)) {
            this.activeChallenges.add(challenge);
            this.forEachSublayer(subLayer -> subLayer.onChallengeAdd(challenge));
        }
    }

    public void startChallenge(class_6880<Challenge> challenge) {
        if (!this.activeChallenges.contains(challenge)) {
            this.activeChallenges.add(challenge);
            this.forEachSublayer(subLayer -> subLayer.onChallengeStart(challenge));
        }
    }

    public void removeChallenge(class_6880<Challenge> challenge) {
        if (this.activeChallenges.remove(challenge)) {
            this.forEachSublayer(subLayer -> subLayer.onChallengeRemove(challenge));
        }
    }

    public void completeChallenge(class_6880<Challenge> challenge) {
        if (this.activeChallenges.remove(challenge)) {
            this.forEachSublayer(subLayer -> subLayer.onChallengeComplete(challenge));
        }
    }

    public List<class_6880<Challenge>> getActiveChallenges() {
        return this.activeChallenges;
    }

    public void onLoginDisconnect(class_635 handler, class_310 client) {
        this.clear();
    }

    public void onLoginStart(class_635 handler, class_310 client) {
        this.clear();
    }

    public void onEndTick(class_638 world) {
        this.playerManager.tick();
        this.forEachSublayer(subLayer -> subLayer.tick(world));
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            if (this.isQueueingPhase()) {
                this.hider = false;
                this.seeker = false;
            } else {
                this.hider = this.isHider((class_1657)player);
                boolean bl = this.seeker = !this.hider && this.getGamePlayer(player.method_5667()) != null;
            }
        }
        if (this.isSeekingPhase()) {
            if (this.getActiveQuestion() != null && this.getHider(world) != null && this.getActiveQuestion().tick()) {
                this.activeQuestion = null;
            }
            if (this.seekerTpCooldown > 0) {
                --this.seekerTpCooldown;
            }
            if (this.seekerQuestionCooldown > 0) {
                --this.seekerQuestionCooldown;
            }
            if (this.isHider() && this.rewardScreenDelay > 0 && --this.rewardScreenDelay == 0) {
                class_310.method_1551().method_1507((class_437)new PowerupRewardScreen());
            }
        }
    }

    public void onPlayerOnline(class_640 playerListEntry) {
        ClientGamePlayer gamePlayer = this.playerManager.getGamePlayer(playerListEntry.method_2966().getId());
        if (gamePlayer != null) {
            gamePlayer.setTexturesSupplier(playerListEntry.field_45607);
        }
    }

    public void render(class_332 ctx, class_9779 tickCounter) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        this.forEachSublayer(subLayer -> subLayer.render(ctx, tickCounter, world));
    }

    public void forEachSublayer(Consumer<GameSubLayer> consumer) {
        for (GameSubLayer subLayer : this.subLayers) {
            consumer.accept(subLayer);
        }
    }

    public void announceHider(UUID hider, List<UUID> seekers, int delay) {
        ClientGamePlayer hiderPlayer = (ClientGamePlayer)this.getGamePlayer(hider);
        if (hiderPlayer == null) {
            return;
        }
        ArrayList<ClientGamePlayer> seekerPlayers = new ArrayList<ClientGamePlayer>();
        for (UUID seeker : seekers) {
            ClientGamePlayer seekerPlayer = (ClientGamePlayer)this.getGamePlayer(seeker);
            if (seekerPlayer == null) continue;
            seekerPlayers.add(seekerPlayer);
        }
        if (seekerPlayers.isEmpty()) {
            return;
        }
        this.forEachSublayer(subLayer -> subLayer.onHiderAnnouncement(hiderPlayer, seekerPlayers, delay));
    }

    public void onHidingSpotRequirements(List<HidingSpotRequirementsS2CPayload.Entry> entries) {
        if (this.isHidingPhase() && this.isHider()) {
            this.acceptableHidingSpot = !entries.isEmpty() && entries.stream().allMatch(HidingSpotRequirementsS2CPayload.Entry::acceptable);
            this.forEachSublayer(subLayer -> subLayer.onHidingSpotRequirements(entries));
        }
    }

    public void acceptReward(PowerupReward reward, PowerupReward.Cause cause) {
        this.hiderPowerups.getRewardQueue().add(reward);
        this.rewardScreenDelay = 60;
    }

    public class_2960 getFabricId() {
        return ID;
    }

    public void method_14491(class_3300 manager) {
        this.forEachSublayer(GameSubLayer::onReload);
    }

    public void playSound(class_3414 soundEvent, float pitch, float volume) {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)soundEvent, (float)pitch, (float)volume));
    }

    public void playSound(class_3414 soundEvent, float pitch) {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)soundEvent, (float)pitch));
    }

    @Nullable
    public Powerup getHandPowerup(int selectedSlot) {
        List<Powerup> powerups = this.hiderPowerups.getHand();
        if (selectedSlot >= powerups.size() || selectedSlot < 0) {
            return null;
        }
        return powerups.get(selectedSlot);
    }
}

