/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.hideandseek.client.layer;

import com.eightsidedsquare.hideandseek.client.layer.GameLayer;
import com.eightsidedsquare.hideandseek.client.layer.GameSubLayer;
import com.eightsidedsquare.hideandseek.client.layer.LeaderboardSubLayer;
import com.eightsidedsquare.hideandseek.client.util.ClientGamePlayer;
import com.eightsidedsquare.hideandseek.common.network.EndResultsS2CPayload;
import com.eightsidedsquare.hideandseek.core.ModInit;
import com.eightsidedsquare.hideandseek.core.ModSounds;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3544;
import net.minecraft.class_5348;
import net.minecraft.class_638;
import net.minecraft.class_7532;
import net.minecraft.class_9779;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class EndResultsSubLayer
extends GameSubLayer {
    public static EndResultsSubLayer instance;
    private static final class_2960 RESULT_FIRST;
    private static final class_2960 RESULT_SECOND;
    private static final class_2960 RESULT_THIRD;
    private final List<Plaque> plaques = new ObjectArrayList();
    private int ticks;
    private int delay;

    public EndResultsSubLayer(GameLayer gameLayer) {
        super(gameLayer);
        instance = this;
    }

    private void clear() {
        this.plaques.clear();
        this.ticks = 0;
        this.delay = 0;
    }

    public void accept(EndResultsS2CPayload payload) {
        this.clear();
        this.plaques.add(new Plaque(payload.first()));
        this.plaques.add(new Plaque(payload.second()));
        payload.third().ifPresent(third -> this.plaques.add(new Plaque((EndResultsS2CPayload.Entry)third)));
        this.delay = payload.delay();
        if (this.delay == 0) {
            this.playSound();
            LeaderboardSubLayer.instance.onClear();
        }
    }

    private void playSound() {
        this.gameLayer.playSound(ModSounds.ANNOUNCE_HIDER, 1.25f, 2.0f);
    }

    @Override
    public void onClear() {
        this.clear();
    }

    @Override
    public void tick(class_638 world) {
        if (this.delay > 0) {
            if (--this.delay == 0) {
                this.playSound();
                LeaderboardSubLayer.instance.onClear();
            }
        } else if (!this.plaques.isEmpty()) {
            if (++this.ticks >= 150) {
                this.clear();
            } else {
                for (int i = 0; i < this.plaques.size(); ++i) {
                    this.plaques.get(i).tick(i, this.ticks);
                }
            }
        }
    }

    @Override
    public void render(class_332 ctx, class_9779 tickCounter, class_638 world) {
        if (this.delay > 0 || this.plaques.isEmpty()) {
            return;
        }
        class_327 textRenderer = class_310.method_1551().field_1772;
        float tickProgress = tickCounter.method_60637(true);
        float time = (float)this.ticks + tickProgress;
        float alpha = class_3532.method_15363((float)((time - 150.0f) * -0.1f), (float)0.0f, (float)1.0f);
        for (int i = 0; i < this.plaques.size(); ++i) {
            this.plaques.get(i).render(ctx, textRenderer, i, tickProgress, alpha);
        }
    }

    static {
        RESULT_FIRST = ModInit.id("result_first");
        RESULT_SECOND = ModInit.id("result_second");
        RESULT_THIRD = ModInit.id("result_third");
    }

    public static class Plaque {
        @Nullable
        final class_2960 playerTexture;
        final class_2561 text;
        final Vector2f lastPos;
        final Vector2f pos;
        final Vector2f targetPos;

        public Plaque(EndResultsS2CPayload.Entry entry) {
            ClientGamePlayer gamePlayer = (ClientGamePlayer)GameLayer.INSTANCE.getGamePlayer(entry.uuid());
            class_638 world = class_310.method_1551().field_1687;
            float tickRate = world == null ? 20.0f : world.method_54719().method_54748();
            this.playerTexture = gamePlayer == null ? null : gamePlayer.getSkinTexture();
            this.text = class_2561.method_43470((String)class_3544.method_15439((int)entry.time(), (float)tickRate));
            this.pos = new Vector2f((float)class_310.method_1551().method_22683().method_4486() / 2.0f, (float)class_310.method_1551().method_22683().method_4502() * -0.5f);
            this.lastPos = new Vector2f((Vector2fc)this.pos);
            this.targetPos = new Vector2f((Vector2fc)this.pos);
        }

        public void tick(int i, int time) {
            this.lastPos.set((Vector2fc)this.pos);
            float halfHeight = (float)class_310.method_1551().method_22683().method_4502() / 2.0f;
            if (i == 0 && time == 58) {
                this.targetPos.y = halfHeight - 30.0f;
            } else if (i == 1 && time == 30) {
                this.targetPos.y = halfHeight;
            } else if (i == 2 && time == 10) {
                this.targetPos.y = halfHeight + 30.0f;
            }
            this.pos.set(class_3532.method_16439((float)0.5f, (float)this.pos.x, (float)this.targetPos.x), class_3532.method_16439((float)0.5f, (float)this.pos.y, (float)this.targetPos.y));
        }

        public void render(class_332 ctx, class_327 textRenderer, int i, float tickProgress, float alpha) {
            int color = class_9848.method_71346((float)alpha, (int)-1);
            class_2960 texture = switch (i) {
                case 0 -> RESULT_FIRST;
                case 1 -> RESULT_SECOND;
                default -> RESULT_THIRD;
            };
            Matrix3x2fStack matrices = ctx.method_51448();
            matrices.pushMatrix();
            matrices.translate(class_3532.method_16439((float)tickProgress, (float)this.lastPos.x, (float)this.pos.x), class_3532.method_16439((float)tickProgress, (float)this.lastPos.y, (float)this.pos.y));
            matrices.pushMatrix();
            matrices.translate(-47.0f, -10.5f);
            ctx.method_52707(class_10799.field_56883, texture, 0, 0, 94, 21, color);
            if (this.playerTexture != null) {
                class_7532.method_44445((class_332)ctx, (class_2960)this.playerTexture, (int)2, (int)2, (int)16, (boolean)true, (boolean)false, (int)color);
            }
            matrices.popMatrix();
            ctx.method_51448().translate(45.0f, -1.0f);
            ctx.method_51448().scale(2.0f);
            ctx.method_51448().translate((float)(-textRenderer.method_27525((class_5348)this.text)), -3.5f);
            ctx.method_51439(textRenderer, this.text, 0, 0, color, true);
            matrices.popMatrix();
        }
    }
}

