/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.hideandseek.client.layer;

import com.eightsidedsquare.hideandseek.client.layer.GameLayer;
import com.eightsidedsquare.hideandseek.client.layer.GameSubLayer;
import com.eightsidedsquare.hideandseek.common.game.challenge.Challenge;
import com.eightsidedsquare.hideandseek.core.ModInit;
import com.eightsidedsquare.hideandseek.core.ModSounds;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_9779;
import net.minecraft.class_9848;

public class ChallengeSubLayer
extends GameSubLayer {
    private static final class_2960 CHALLENGE = ModInit.id("challenge");
    private static final class_2960 COMPLETED_CHALLENGE = ModInit.id("completed_challenge");
    private final List<ChallengeElement> elements = new ObjectArrayList();

    public ChallengeSubLayer(GameLayer gameLayer) {
        super(gameLayer);
    }

    @Override
    public void render(class_332 ctx, class_9779 tickCounter, class_638 world) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        float tickProgress = tickCounter.method_60637(true);
        for (ChallengeElement element : this.elements) {
            element.render(ctx, textRenderer, tickProgress);
        }
    }

    @Override
    public void tick(class_638 world) {
        this.elements.removeIf(element -> element.removed);
        for (int i = 0; i < this.elements.size(); ++i) {
            this.elements.get(i).tick(2.0f, i * 21 + 2, 0.3f);
        }
    }

    private void addElement(class_6880<Challenge> challenge, boolean bounce) {
        for (ChallengeElement element : this.elements) {
            if (!element.challenge.equals(challenge)) continue;
            return;
        }
        int size = this.elements.size();
        this.elements.add(new ChallengeElement(challenge, 2.0f, size * 21 + 2, bounce));
    }

    @Override
    public void onChallengeAdd(class_6880<Challenge> challenge) {
        this.addElement(challenge, false);
    }

    @Override
    public void onChallengeStart(class_6880<Challenge> challenge) {
        this.gameLayer.playSound(ModSounds.START_CHALLENGE, 1.0f, 2.0f);
        this.addElement(challenge, true);
    }

    @Override
    public void onChallengeRemove(class_6880<Challenge> challenge) {
        for (ChallengeElement element : this.elements) {
            if (!element.challenge.equals(challenge)) continue;
            element.removed = true;
            return;
        }
    }

    @Override
    public void onChallengeComplete(class_6880<Challenge> challenge) {
        this.gameLayer.playSound(ModSounds.COMPLETE_CHALLENGE, 1.0f, 2.0f);
        for (ChallengeElement element : this.elements) {
            if (!element.challenge.equals(challenge)) continue;
            element.complete = true;
            element.bouncing = true;
            return;
        }
    }

    @Override
    public void onClear() {
        this.elements.clear();
    }

    public static class ChallengeElement {
        private static final int MAX_BOUNCE_TICKS = 15;
        private static final int WIDTH = 135;
        private static final int HEIGHT = 19;
        private static final float HALF_WIDTH = 67.5f;
        private static final float HALF_HEIGHT = 9.5f;
        public final class_6880<Challenge> challenge;
        public float lastX;
        public float lastY;
        public float x;
        public float y;
        public int bounceTicks;
        public boolean bouncing;
        public boolean complete = false;
        public boolean removed = false;

        public ChallengeElement(class_6880<Challenge> challenge, float x, float y, boolean bounce) {
            this.challenge = challenge;
            this.x = x;
            this.y = y;
            this.lastX = x;
            this.lastY = y;
            this.bouncing = bounce;
        }

        public void tick(float targetX, float targetY, float strength) {
            this.lastX = this.x;
            this.lastY = this.y;
            this.x = class_3532.method_16439((float)strength, (float)this.x, (float)targetX);
            this.y = class_3532.method_16439((float)strength, (float)this.y, (float)targetY);
            if (this.bouncing && ++this.bounceTicks >= 15) {
                this.bounceTicks = 0;
                this.bouncing = false;
                if (this.complete) {
                    this.removed = true;
                }
            }
        }

        public void render(class_332 ctx, class_327 textRenderer, float tickProgress) {
            class_2960 texture;
            float x = class_3532.method_16439((float)tickProgress, (float)this.lastX, (float)this.x);
            float y = class_3532.method_16439((float)tickProgress, (float)this.lastY, (float)this.y);
            float bounceProgress = 1.0f - ((float)this.bounceTicks + tickProgress) / 15.0f;
            ctx.method_51448().pushMatrix();
            ctx.method_51448().translate(x + 67.5f, y + 9.5f);
            if (this.bouncing) {
                ctx.method_51448().scale(class_3532.method_15374((float)((float)Math.PI * 2 * (1.0f - bounceProgress * bounceProgress))) * bounceProgress * 0.125f + 1.0f);
            }
            ctx.method_51448().translate(-67.5f, -9.5f);
            class_2960 class_29602 = texture = this.complete ? COMPLETED_CHALLENGE : CHALLENGE;
            int color = this.complete ? class_9848.method_71346((float)(this.removed ? 0.0f : bounceProgress), (int)-1) : -1;
            ctx.method_52707(class_10799.field_56883, texture, 0, 0, 135, 19, color);
            class_339.method_52718((class_332)ctx, (class_327)textRenderer, (class_2561)class_2561.method_43471((String)((Challenge)this.challenge.comp_349()).translationKey()), (int)19, (int)1, (int)132, (int)17, (int)color);
            ctx.method_51448().popMatrix();
        }
    }
}

