/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.hideandseek.client.layer;

import com.eightsidedsquare.hideandseek.client.layer.GameLayer;
import com.eightsidedsquare.hideandseek.client.layer.GameSubLayer;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5348;
import net.minecraft.class_638;
import net.minecraft.class_9779;
import net.minecraft.class_9848;
import org.joml.Matrix3x2fStack;

public class AnnouncementSubLayer
extends GameSubLayer {
    public static AnnouncementSubLayer instance;
    private static final int MAX_AGE = 60;
    private final List<Announcement> announcements = new ObjectArrayList();

    public AnnouncementSubLayer(GameLayer gameLayer) {
        super(gameLayer);
        instance = this;
    }

    public void addTitle(class_2561 text, float y, float size) {
        this.announcements.add(new Announcement(text, y, size));
    }

    private void clear() {
        this.announcements.clear();
    }

    @Override
    public void onClear() {
        this.clear();
    }

    @Override
    public void tick(class_638 world) {
        this.announcements.removeIf(Announcement::tick);
    }

    @Override
    public void render(class_332 ctx, class_9779 tickCounter, class_638 world) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        float tickProgress = tickCounter.method_60637(true);
        ctx.method_51448().pushMatrix();
        ctx.method_51448().translate((float)ctx.method_51421() / 2.0f, (float)ctx.method_51443() / 2.0f);
        this.announcements.forEach(announcement -> announcement.render(ctx, textRenderer, tickProgress));
        ctx.method_51448().popMatrix();
    }

    public static class Announcement {
        final class_2561 text;
        final float y;
        final float scale;
        int age;

        public Announcement(class_2561 text, float y, float scale) {
            this.text = text;
            this.y = y;
            this.scale = scale;
        }

        public boolean tick() {
            return ++this.age >= 60;
        }

        public void render(class_332 ctx, class_327 textRenderer, float tickProgress) {
            float time = (float)this.age + tickProgress;
            float baseAlpha = class_3532.method_15363((float)(0.2f * time), (float)0.0f, (float)1.0f) * class_3532.method_15363((float)(-0.2f * (time - 60.0f)), (float)0.0f, (float)1.0f);
            float layerAlpha = class_3532.method_15363((float)(-0.075f * time + 1.0f), (float)0.0f, (float)1.0f);
            float layerScale = 1.0f + time * 0.025f;
            float offsetX = (float)textRenderer.method_27525((class_5348)this.text) / -2.0f;
            float offsetY = -3.5f;
            Matrix3x2fStack matrices = ctx.method_51448();
            matrices.pushMatrix();
            matrices.translate(0.0f, this.y);
            matrices.scale(this.scale);
            matrices.pushMatrix();
            matrices.translate(offsetX, offsetY);
            ctx.method_51439(textRenderer, this.text, 0, 0, class_9848.method_71346((float)baseAlpha, (int)-1), true);
            matrices.popMatrix();
            if (layerAlpha > 0.0f) {
                matrices.scale(layerScale);
                matrices.translate(offsetX, offsetY);
                ctx.method_51439(textRenderer, this.text, 0, 0, class_9848.method_71346((float)layerAlpha, (int)-1), false);
            }
            matrices.popMatrix();
        }
    }
}

