/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.hideandseek.client.layer;

import com.eightsidedsquare.hideandseek.client.layer.AnnouncementSubLayer;
import com.eightsidedsquare.hideandseek.client.layer.GameLayer;
import com.eightsidedsquare.hideandseek.client.layer.GameSubLayer;
import com.eightsidedsquare.hideandseek.client.util.ClientGamePlayer;
import com.eightsidedsquare.hideandseek.common.game.player.GamePlayerManagerImpl;
import com.eightsidedsquare.hideandseek.common.game.question.ActiveQuestion;
import com.eightsidedsquare.hideandseek.core.ModInit;
import com.eightsidedsquare.hideandseek.core.ModSounds;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_638;
import net.minecraft.class_7532;
import net.minecraft.class_9779;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class ActiveQuestionSubLayer
extends GameSubLayer {
    private static final class_2960 SPEECH_BUBBLE_LEFT = ModInit.id("speech_bubble_left");
    private static final class_2960 SPEECH_BUBBLE_RIGHT = ModInit.id("speech_bubble_right");
    private static final class_2561 HIDING_TIMER_PAUSED_TEXT = class_2561.method_43471((String)"question.hiding_timer_paused");
    private static final class_2561 QUESTION_CANCELED_TEXT = class_2561.method_43471((String)"hideandseek.question_canceled").method_54663(-44462);
    private final List<SpeechBubble> speechBubbles = new ObjectArrayList();
    @Nullable
    private ActiveQuestion activeQuestion;
    private int waitingTicks;
    private int timeout;
    private int canceledTicks;

    public ActiveQuestionSubLayer(GameLayer gameLayer) {
        super(gameLayer);
    }

    @Override
    public void render(class_332 ctx, class_9779 tickCounter, class_638 world) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        if (this.activeQuestion != null) {
            int y = 0;
            float tickProgress = tickCounter.method_60637(true);
            float alpha = this.timeout > 0 ? class_3532.method_15363((float)(((float)this.timeout - tickProgress) * 0.1f), (float)0.0f, (float)1.0f) : 1.0f;
            List<SpeechBubble> bubbles = this.speechBubbles;
            for (int i = 0; i < bubbles.size(); ++i) {
                SpeechBubble speechBubble = bubbles.get(i);
                speechBubble.render(ctx, textRenderer, tickProgress, alpha);
                y += speechBubble.getHeight();
                if (i != 0 || !this.activeQuestion.isWaitingNow()) continue;
                int x = (ctx.method_51421() - textRenderer.method_27525((class_5348)HIDING_TIMER_PAUSED_TEXT)) / 2;
                float time = (float)this.waitingTicks + tickProgress;
                int color = class_9848.method_71346((float)class_3532.method_15363((float)(time * 0.1f - 1.0f), (float)0.0f, (float)1.0f), (int)class_9848.method_61319((float)((class_3532.method_15374((float)(time * 0.3f)) + 1.0f) / 2.0f), (int)-1, (int)-44462));
                ctx.method_51439(textRenderer, HIDING_TIMER_PAUSED_TEXT, x, y + 8, color, true);
                y += 17;
            }
        }
    }

    @Override
    public void tick(class_638 world) {
        if (this.timeout > 0 && --this.timeout == 0) {
            this.clear();
            return;
        }
        if (this.activeQuestion == null) {
            return;
        }
        if (this.activeQuestion.isCanceled() && this.timeout == 0 && ++this.canceledTicks == 40) {
            this.timeout = 60;
            AnnouncementSubLayer.instance.addTitle(QUESTION_CANCELED_TEXT, 0.0f, 2.0f);
            this.gameLayer.playSound(ModSounds.QUESTION_CANCELED, 1.0f, 2.0f);
        }
        int width = class_310.method_1551().method_22683().method_4486();
        int height = class_310.method_1551().method_22683().method_4502();
        int y = 0;
        for (int i = this.speechBubbles.size() - 1; i >= 0; --i) {
            SpeechBubble speechBubble = this.speechBubbles.get(i);
            speechBubble.tick(y, width, height, this.activeQuestion);
            y += speechBubble.getHeight();
            if (i == 0 && this.activeQuestion.isWaitingNow()) {
                ++this.waitingTicks;
                y += 17;
                continue;
            }
            this.waitingTicks = 0;
        }
    }

    private void clear() {
        this.speechBubbles.clear();
        this.activeQuestion = null;
        this.waitingTicks = 0;
        this.timeout = 0;
        this.canceledTicks = 0;
    }

    @Override
    public void onClear() {
        this.clear();
    }

    @Override
    public void onActiveQuestionSet(@Nullable ActiveQuestion activeQuestion, @Nullable UUID sender, boolean forceClear) {
        if (forceClear) {
            this.clear();
        } else if (activeQuestion != null) {
            this.activeQuestion = activeQuestion;
            if (sender == null || !activeQuestion.isOutbound()) {
                return;
            }
            ClientGamePlayer gamePlayer = (ClientGamePlayer)this.gameLayer.getGamePlayer(sender);
            if (gamePlayer == null) {
                return;
            }
            this.speechBubbles.clear();
            int width = class_310.method_1551().method_22683().method_4486();
            int height = class_310.method_1551().method_22683().method_4502();
            this.gameLayer.playSound(ModSounds.QUESTION_ASK, 1.0f, 2.0f);
            class_5250 text = class_2561.method_43471((String)activeQuestion.getQuestion().getTranslationKey());
            this.speechBubbles.add(new SpeechBubble((float)width / 2.0f, (float)height / 3.0f, this.gameLayer.isHider(), gamePlayer.getSkinTexture(), (class_2561)text));
        }
    }

    @Override
    public void onCluesAdded(List<class_2561> clues) {
        ClientGamePlayer gamePlayer;
        if (this.activeQuestion != null && !clues.isEmpty() && !this.activeQuestion.isCanceled() && (gamePlayer = (ClientGamePlayer)((GamePlayerManagerImpl)this.gameLayer.getPlayerManager()).hider) != null) {
            int width = class_310.method_1551().method_22683().method_4486();
            int height = class_310.method_1551().method_22683().method_4502();
            this.speechBubbles.add(new SpeechBubble((float)width / 2.0f, (float)height / 3.0f, !this.gameLayer.isHider(), gamePlayer.getSkinTexture(), clues.getFirst()));
            this.gameLayer.playSound(ModSounds.QUESTION_RESPONSE, 1.0f, 2.0f);
            this.timeout = 100;
        }
    }

    public static class SpeechBubble {
        final boolean left;
        final class_2960 playerTexture;
        final List<class_5481> lines;
        final int textWidth;
        final int textHeight;
        final int maxSpeechWidth;
        final int maxSpeechHeight;
        final Vector2f lastPos;
        final Vector2f pos;
        final Vector2f targetPos;
        float lastSpeechBubbleScale;
        float speechBubbleScale;
        float lastTextAlpha;
        float textAlpha;
        int age;

        public SpeechBubble(float x, float y, boolean left, class_2960 playerTexture, class_2561 text) {
            this.lastPos = new Vector2f(x, y);
            this.pos = new Vector2f(x, y);
            this.targetPos = new Vector2f(x, y);
            this.left = left;
            this.playerTexture = playerTexture;
            class_327 textRenderer = class_310.method_1551().field_1772;
            this.lines = textRenderer.method_1728((class_5348)text, 100);
            this.textWidth = this.lines.size() == 1 ? textRenderer.method_30880(this.lines.getFirst()) : 100;
            this.textHeight = this.lines.size() * 9;
            this.maxSpeechWidth = this.textWidth + 6;
            this.maxSpeechHeight = this.textHeight + 10;
        }

        public void tick(int y, int width, int height, ActiveQuestion activeQuestion) {
            this.lastSpeechBubbleScale = this.speechBubbleScale;
            this.speechBubbleScale = class_3532.method_16439((float)0.3f, (float)this.speechBubbleScale, (float)1.0f);
            this.lastTextAlpha = this.textAlpha;
            if (this.speechBubbleScale > 0.99f) {
                this.textAlpha = class_3532.method_16439((float)0.3f, (float)this.textAlpha, (float)1.0f);
            }
            this.lastPos.set((Vector2fc)this.pos);
            this.targetPos.set((float)width / 2.0f, activeQuestion.isWaitingNow() ? 5.0f + (float)this.maxSpeechHeight / 2.0f : (float)height / 3.0f - (float)y);
            this.pos.set(class_3532.method_16439((float)0.5f, (float)this.pos.x, (float)this.targetPos.x), class_3532.method_16439((float)0.5f, (float)this.pos.y, (float)this.targetPos.y));
            ++this.age;
        }

        public int getHeight() {
            return this.maxSpeechHeight + 8;
        }

        public void render(class_332 ctx, class_327 textRenderer, float tickProgress, float alpha) {
            float x = class_3532.method_16439((float)tickProgress, (float)this.lastPos.x, (float)this.pos.x);
            float y = class_3532.method_16439((float)tickProgress, (float)this.lastPos.y, (float)this.pos.y);
            float speechBubbleScale = class_3532.method_16439((float)tickProgress, (float)this.lastSpeechBubbleScale, (float)this.speechBubbleScale);
            ctx.method_51448().pushMatrix();
            ctx.method_51448().translate(x, y);
            if (speechBubbleScale > 0.0f) {
                int speechWidth = Math.round(speechBubbleScale * speechBubbleScale * (float)this.maxSpeechWidth);
                int speechHeight = Math.round(speechBubbleScale * (float)this.maxSpeechHeight);
                ctx.method_52707(class_10799.field_56883, this.left ? SPEECH_BUBBLE_LEFT : SPEECH_BUBBLE_RIGHT, this.left ? -this.maxSpeechWidth / 2 : this.maxSpeechWidth / 2 - speechWidth, this.maxSpeechHeight / 2 - speechHeight, speechWidth, speechHeight, class_9848.method_71346((float)alpha, (int)-1));
                float textAlpha = class_3532.method_16439((float)tickProgress, (float)this.lastTextAlpha, (float)this.textAlpha);
                if (textAlpha > 0.0f) {
                    int textX = this.textWidth / -2;
                    int textY = this.textHeight / -2 - 2;
                    int color = class_9848.method_71346((float)(textAlpha * alpha), (int)0);
                    for (int i = 0; i < this.lines.size(); ++i) {
                        ctx.method_51430(textRenderer, this.lines.get(i), textX, textY + i * 9, color, false);
                    }
                }
            }
            int headX = this.left ? this.maxSpeechWidth / -2 - 20 : this.maxSpeechWidth / 2 + 4;
            int headY = this.maxSpeechHeight / 2 - 8;
            class_7532.method_44445((class_332)ctx, (class_2960)this.playerTexture, (int)headX, (int)headY, (int)16, (boolean)true, (boolean)false, (int)class_9848.method_71346((float)alpha, (int)-1));
            ctx.method_51448().popMatrix();
        }
    }
}

