/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.hideandseek.client;

import com.eightsidedsquare.hideandseek.client.layer.AnnouncementSubLayer;
import com.eightsidedsquare.hideandseek.client.layer.EndResultsSubLayer;
import com.eightsidedsquare.hideandseek.client.layer.GameLayer;
import com.eightsidedsquare.hideandseek.client.screen.SeekerSeekingScreen;
import com.eightsidedsquare.hideandseek.client.texture.MinimapTextureManager;
import com.eightsidedsquare.hideandseek.client.util.ClientWorldMarkings;
import com.eightsidedsquare.hideandseek.common.game.challenge.Challenge;
import com.eightsidedsquare.hideandseek.common.network.ActiveQuestionS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.AnnouncementS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.ChallengeStatusS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.ClearWorldMarkingsS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.CluesS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.EndResultsS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.GamePlayerListS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.HiderAnnouncementS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.HiderStatusS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.HidingSpotRequirementsS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.HidingTimeS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.PowerupRewardS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.QuestionStatesS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.ResetGameS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.SeekerQuestionCooldownS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.SeekerTpCooldownS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.SyncGameStateS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.SyncPowerupsS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.WorldMarkingChangesS2CPayload;
import com.eightsidedsquare.hideandseek.common.network.WorldMarkingsS2CPayload;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.UUID;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_3414;
import net.minecraft.class_437;
import net.minecraft.class_634;
import net.minecraft.class_6880;

public interface ModClientNetworking {
    public static void init() {
        ClientPlayNetworking.registerGlobalReceiver(ActiveQuestionS2CPayload.ID, (payload, ctx) -> GameLayer.INSTANCE.setActiveQuestion(payload.activeQuestion().orElse(null), payload.sender().orElse(null), payload.forceClear()));
        ClientPlayNetworking.registerGlobalReceiver(AnnouncementS2CPayload.ID, (payload, ctx) -> {
            AnnouncementSubLayer.instance.addTitle(payload.text(), payload.y(), payload.size());
            payload.soundEvent().ifPresent(soundEvent -> GameLayer.INSTANCE.playSound((class_3414)soundEvent, 1.0f, 2.0f));
        });
        ClientPlayNetworking.registerGlobalReceiver(ChallengeStatusS2CPayload.ID, (payload, ctx) -> payload.statuses().forEach((challenge, status) -> {
            switch (status) {
                case ADD: {
                    GameLayer.INSTANCE.addChallenge((class_6880<Challenge>)challenge);
                    break;
                }
                case START: {
                    GameLayer.INSTANCE.startChallenge((class_6880<Challenge>)challenge);
                    break;
                }
                case REMOVE: {
                    GameLayer.INSTANCE.removeChallenge((class_6880<Challenge>)challenge);
                    break;
                }
                case COMPLETE: {
                    GameLayer.INSTANCE.completeChallenge((class_6880<Challenge>)challenge);
                }
            }
        }));
        ClientPlayNetworking.registerGlobalReceiver(ClearWorldMarkingsS2CPayload.ID, (payload, ctx) -> ClientWorldMarkings.INSTANCE.set(null));
        ClientPlayNetworking.registerGlobalReceiver(CluesS2CPayload.ID, (payload, ctx) -> {
            if (payload.clues().isEmpty()) {
                GameLayer.INSTANCE.getClues().clear();
            } else {
                GameLayer.INSTANCE.addClues(payload.clues());
            }
            class_437 patt0$temp = ctx.client().field_1755;
            if (patt0$temp instanceof SeekerSeekingScreen) {
                SeekerSeekingScreen screen = (SeekerSeekingScreen)patt0$temp;
                screen.refreshCluePages();
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(EndResultsS2CPayload.ID, (payload, ctx) -> EndResultsSubLayer.instance.accept((EndResultsS2CPayload)payload));
        ClientPlayNetworking.registerGlobalReceiver(GamePlayerListS2CPayload.ID, (payload, ctx) -> {
            class_634 networkHandler = ctx.client().method_1562();
            if (networkHandler == null) {
                return;
            }
            GameLayer.INSTANCE.setPlayers(networkHandler, payload.entries());
            HiderStatusS2CPayload hiderStatus = payload.hiderStatus();
            GameLayer.INSTANCE.setHider(hiderStatus.hider().orElse(null), hiderStatus.currentHiderTime(), hiderStatus.tickHiderTime());
        });
        ClientPlayNetworking.registerGlobalReceiver(HiderAnnouncementS2CPayload.ID, (payload, ctx) -> GameLayer.INSTANCE.announceHider(payload.hider(), payload.seekers(), payload.delay()));
        ClientPlayNetworking.registerGlobalReceiver(HiderStatusS2CPayload.ID, (payload, ctx) -> GameLayer.INSTANCE.setHider(payload.hider().orElse(null), payload.currentHiderTime(), payload.tickHiderTime()));
        ClientPlayNetworking.registerGlobalReceiver(HidingSpotRequirementsS2CPayload.ID, (payload, ctx) -> GameLayer.INSTANCE.onHidingSpotRequirements(payload.entries()));
        ClientPlayNetworking.registerGlobalReceiver(HidingTimeS2CPayload.ID, (payload, ctx) -> GameLayer.INSTANCE.setHidingTimes((Object2IntMap<UUID>)payload.times()));
        ClientPlayNetworking.registerGlobalReceiver(PowerupRewardS2CPayload.ID, (payload, ctx) -> GameLayer.INSTANCE.acceptReward(payload.reward(), payload.cause()));
        ClientPlayNetworking.registerGlobalReceiver(QuestionStatesS2CPayload.ID, (payload, ctx) -> GameLayer.INSTANCE.getQuestionStates().accept(payload.states()));
        ClientPlayNetworking.registerGlobalReceiver(ResetGameS2CPayload.ID, (payload, ctx) -> GameLayer.INSTANCE.clear());
        ClientPlayNetworking.registerGlobalReceiver(SeekerQuestionCooldownS2CPayload.ID, (payload, ctx) -> GameLayer.INSTANCE.setSeekerQuestionCooldown(payload.cooldown()));
        ClientPlayNetworking.registerGlobalReceiver(SeekerTpCooldownS2CPayload.ID, (payload, ctx) -> GameLayer.INSTANCE.setSeekerTpCooldown(payload.cooldown()));
        ClientPlayNetworking.registerGlobalReceiver(SyncGameStateS2CPayload.ID, (payload, ctx) -> {
            boolean resetMinimap = payload.gameState().getDimensions() != GameLayer.INSTANCE.getDimensions();
            GameLayer.INSTANCE.setGameState(payload.gameState());
            if (resetMinimap) {
                MinimapTextureManager.INSTANCE.resetTexture();
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(SyncPowerupsS2CPayload.ID, (payload, ctx) -> GameLayer.INSTANCE.setHiderPowerups(payload.powerups()));
        ClientPlayNetworking.registerGlobalReceiver(WorldMarkingsS2CPayload.ID, (payload, ctx) -> payload.data().ifPresentOrElse(ClientWorldMarkings.INSTANCE::set, ClientWorldMarkings.INSTANCE::clear));
        ClientPlayNetworking.registerGlobalReceiver(WorldMarkingChangesS2CPayload.ID, (payload, ctx) -> {
            int size = payload.positions().length;
            for (int i = 0; i < size; ++i) {
                ClientWorldMarkings.INSTANCE.set(payload.positions()[i], payload.markings()[i]);
            }
            MinimapTextureManager.INSTANCE.uploadMarkingTexture();
        });
    }
}

